% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_source.R
\name{schema_methods}
\alias{schema_methods}
\alias{schema_update_source}
\alias{schema_get_table}
\alias{schema_plot_deps}
\alias{schema_simulate}
\title{Schema object methods}
\usage{
schema_update_source(
  schema,
  file,
  faker_opts = getOption("dfkr_options", default_faker_opts)
)

schema_get_table(schema, table_name)

schema_plot_deps(schema, table_name)

schema_simulate(schema)
}
\arguments{
\item{schema}{Schema object keeping table dependency graph.}

\item{file}{Path to schema configuration yaml file.}

\item{faker_opts}{Structure sourcing and columns simulation config.}

\item{table_name}{Name of the table.}
}
\description{
The set of methods that can be used on schema object returned by \code{\link{schema_source}} function.
}
\details{
The methods are:
\itemize{
  \item{schema_update_source}{ Update schema dependency graph based on provided file.}
  \item{schema_simulate}{ Run data simulation process.}
  \item{schema_get_table}{ Get simulated table value.}
  \item{schema_plot_deps}{ Plot inter or inner table dependecies.}
}
}
