% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceStudy.R
\name{DataSpaceStudy}
\alias{DataSpaceStudy}
\title{The DataSpaceStudy class}
\description{
The DataSpaceStudy class

The DataSpaceStudy class
}
\section{Constructor}{

\code{DataSpaceConnection$getStudy()}
\code{DataSpaceConnection$getGroup()}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()

# Connect to cvd408 (Initiate a DataSpaceStudy object)
# https://dataspace.cavd.org/cds/CAVD/app.view#learn/learn/Study/cvd408?q=408
cvd408 <- con$getStudy("cvd408")
cvd408

# Retrieve Neutralizing antibody dataset (NAb) for cvd408 from DataSpace
NAb <- cvd408$getDataset("NAb")

# Get variable information of the NAb dataset
cvd408$getDatasetDescription("NAb")

# Take a look at cvd408's treatment arm information
cvd408$treatmentArm

# Clear cache of a study object
cvd408$clearCache()

# Connect to the NYVAC durability comparison group
# https://dataspace.cavd.org/cds/CAVD/app.view#group/groupsummary/220
nyvac <- con$getGroup(220)

# Connect to all studies
cvd <- con$getStudy("")

# Refresh the study object to update available datasets and treatment info
cvd$refresh()
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceConnection}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{study}}{A character. The study name.}

\item{\code{config}}{A list. Stores configuration of the connection object such
as URL, path and username.}

\item{\code{availableDatasets}}{A data.table. The table of datasets available in
the \code{DataSpaceStudy} object.}

\item{\code{cache}}{A list. Stores the data to avoid downloading the same tables
multiple times.}

\item{\code{dataDir}}{A character. Default directory for storing nonstandard
datasets. Set with \code{setDataDir(dataDir)}.}

\item{\code{treatmentArm}}{A data.table. The table of treatment arm
information for the connected study. Not available for all study
connection.}

\item{\code{group}}{A character. The group name.}

\item{\code{studyInfo}}{A list. Stores the information about the study.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSpaceStudy$new()}}
\item \href{#method-print}{\code{DataSpaceStudy$print()}}
\item \href{#method-getDataset}{\code{DataSpaceStudy$getDataset()}}
\item \href{#method-clearCache}{\code{DataSpaceStudy$clearCache()}}
\item \href{#method-getDatasetDescription}{\code{DataSpaceStudy$getDatasetDescription()}}
\item \href{#method-setDataDir}{\code{DataSpaceStudy$setDataDir()}}
\item \href{#method-refresh}{\code{DataSpaceStudy$refresh()}}
\item \href{#method-clone}{\code{DataSpaceStudy$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize \code{DataSpaceStudy} class.
See \code{\link{DataSpaceConnection}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$new(study = NULL, config = NULL, group = NULL, studyInfo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{study}}{A character. Name of the study to retrieve.}

\item{\code{config}}{A list. Stores configuration of the connection object such
as URL, path and username.}

\item{\code{group}}{An integer. ID of the group to retrieve.}

\item{\code{studyInfo}}{A list. Stores the information about the study.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print \code{DataSpaceStudy} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDataset"></a>}}
\if{latex}{\out{\hypertarget{method-getDataset}{}}}
\subsection{Method \code{getDataset()}}{
Get a dataset from the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$getDataset(
  datasetName,
  mergeExtra = FALSE,
  colFilter = NULL,
  reload = FALSE,
  outputDir = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetName}}{A character. Name of the dataset to retrieve.}

\item{\code{mergeExtra}}{A logical. If set to TRUE, merge extra information.
Ignored for non-integrated datasets.}

\item{\code{colFilter}}{A matrix. A filter as returned by Rlabkey's
\code{\link[Rlabkey]{makeFilter}}.}

\item{\code{reload}}{A logical. If set to TRUE, download the dataset, whether
a cached version exist or not.}

\item{\code{outputDir}}{A character. Optional, specifies directory to download
nonstandard datasets. If \code{NULL}, data will be downloaded to
\code{dataDir}, set with \code{setDataDir(dataDir)}. If \code{dataDir}
is not set, and \code{outputDir} is \code{NULL}, a tmp directory will be
used.}

\item{\code{...}}{Extra arguments to be passed to
\code{\link[Rlabkey]{labkey.selectRows}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clearCache"></a>}}
\if{latex}{\out{\hypertarget{method-clearCache}{}}}
\subsection{Method \code{clearCache()}}{
Clear \code{cache}. Remove downloaded datasets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$clearCache()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDatasetDescription"></a>}}
\if{latex}{\out{\hypertarget{method-getDatasetDescription}{}}}
\subsection{Method \code{getDatasetDescription()}}{
Get variable information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$getDatasetDescription(datasetName, outputDir = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetName}}{A character. Name of the dataset to retrieve.}

\item{\code{outputDir}}{A character. Directory path.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDataDir"></a>}}
\if{latex}{\out{\hypertarget{method-setDataDir}{}}}
\subsection{Method \code{setDataDir()}}{
Set default directory to download non-integrated datasets. If no
\code{dataDir} is set, a tmp directory will be used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$setDataDir(dataDir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataDir}}{A character. Directory path.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-refresh}{}}}
\subsection{Method \code{refresh()}}{
Refresh the study object to update available datasets and treatment info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
