## Set STAGING to TRUE in .Renviron to run tests against staging server.
onStaging <- identical(tolower(Sys.getenv("STAGING")), "true")
baseUrl <- ifelse(onStaging, "https://dataspace-staging.cavd.org", "https://dataspace.cavd.org")

## build objects for testing column names for standardized assays
.NABNAMES <- c(
  "participant_id",
  "participant_visit",
  "visit_day",
  "assay_identifier",
  "summary_level",
  "specimen_type",
  "antigen",
  "antigen_type",
  "virus",
  "virus_type",
  "virus_insert_name",
  "clade",
  "neutralization_tier",
  "tier_clade_virus",
  "target_cell",
  "initial_dilution",
  "titer_ic50",
  "titer_ic80",
  "response_call",
  "nab_lab_source_key",
  "lab_code",
  "exp_assayid",
  "titer_id50",
  "titer_id80",
  "nab_response_id50",
  "nab_response_id80",
  "slope",
  "vaccine_matched",
  "study_prot",
  "virus_full_name",
  "virus_species",
  "virus_host_cell",
  "virus_backbone"
)

.ICSNAMES <- c(
  "participant_id",
  "participant_visit",
  "visit_day",
  "assay_identifier",
  "summary_level",
  "cell_type",
  "cell_name",
  "antigen",
  "antigen_type",
  "peptide_pool",
  "protein",
  "protein_panel",
  "protein_panel_protein",
  "protein_panel_protein_peptide_pool",
  "specimen_type",
  "functional_marker_name",
  "functional_marker_type",
  "clade",
  "vaccine_matched",
  "response_call",
  "pctpos",
  "pctpos_adj",
  "pctpos_neg",
  "lab_code",
  "exp_assayid",
  "ics_lab_source_key",
  "response_method",
  "control",
  "pooled_info",
  "study_prot",
  "functionality_score",
  "polyfunctionality_score"
)

.BAMANAMES <- c(
  "participant_id",
  "participant_visit",
  "visit_day",
  "specimen_type",
  "assay_identifier",
  "summary_level",
  "antigen",
  "antigen_type",
  "protein",
  "clade",
  "vaccine_matched",
  "detection_ligand",
  "instrument_code",
  "response_call",
  "dilution",
  "mfi_delta",
  "mfi_raw",
  "mfi_blank",
  "bama_lab_source_key",
  "lab_code",
  "exp_assayid",
  "antibody_isotype",
  "mfi_bkgd",
  "mfi_bkgd_blank",
  "auc",
  "study_prot"
)

.ELINAMES <- c(
  "participant_id",
  "participant_visit",
  "visit_day",
  "assay_identifier",
  "summary_level",
  "antigen",
  "antigen_type",
  "peptide_pool",
  "protein",
  "protein_panel",
  "protein_panel_protein",
  "protein_panel_protein_peptide_pool",
  "clade",
  "cell_type",
  "cell_name",
  "specimen_type",
  "functional_marker_name",
  "functional_marker_type",
  "response_call",
  "mean_sfc",
  "mean_sfc_neg",
  "mean_sfc_raw",
  "els_ifng_lab_source_key",
  "lab_code",
  "exp_assayid",
  "vaccine_matched",
  "study_prot"
)

.PKNAMES <- c(
  "participant_id",
  "participant_visit",
  "visit_day",
  "study_prot",
  "visit_code",
  "visit_time_label",
  "hours_post_initial_infusion",
  "hours_post_recent_infusion",
  "source_assay",
  "lab_code",
  "specimen_type",
  "assay_identifier",
  "summary_level",
  "mab_name_source",
  "mab_mix_name_std",
  "mab_mix_label",
  "mab_mix_id",
  "mab_concentration",
  "mab_concentration_units"
)
