% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connect.R
\name{createDbiConnectionDetails}
\alias{createDbiConnectionDetails}
\title{Create DBI connection details}
\usage{
createDbiConnectionDetails(dbms, drv, ...)
}
\arguments{
\item{dbms}{The type of DBMS running on the server. Valid values are
\itemize{
\item "oracle" for Oracle
\item "postgresql" for PostgreSQL
\item "redshift" for Amazon Redshift
\item "sql server" for Microsoft SQL Server
\item "pdw" for Microsoft Parallel Data Warehouse (PDW)
\item "netezza" for IBM Netezza
\item "bigquery" for Google BigQuery
\item "sqlite" for SQLite
\item "sqlite extended" for SQLite with extended types (DATE and DATETIME)
\item "spark" for Spark
\item "snowflake" for Snowflake
}}

\item{drv}{An object that inherits from DBIDriver, or an existing DBIConnection object
(in order to clone an existing connection).}

\item{...}{authentication arguments needed by the DBMS instance; these typically
include user, password, host, port, dbname, etc. For details see the appropriate DBIDriver}
}
\value{
A list with all the details needed to connect to a database.
}
\description{
For advanced users only. This function will allow \code{DatabaseConnector} to wrap any DBI driver. Using a driver that
\code{DatabaseConnector} hasn't been tested with may give unpredictable performance. Use at your own risk. No
support will be provided.
}
