% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_helper_functions.R,
%   R/design_print_summary.R
\name{post_design}
\alias{post_design}
\alias{print_code}
\alias{print.design}
\alias{summary.design}
\title{Explore your design}
\usage{
print_code(design)

\method{print}{design}(x, verbose = TRUE, ...)

\method{summary}{design}(object, verbose = TRUE, ...)
}
\arguments{
\item{design}{A design object, typically created using the + operator}

\item{x}{a design object, typically created using the + operator}

\item{verbose}{an indicator for printing a long summary of the design, defaults to \code{TRUE}}

\item{...}{optional arguments to be sent to summary function}

\item{object}{a design object created using the + operator}
}
\description{
Explore your design

Print code to recreate a design
}
\examples{

design <-
  declare_population(N = 500, noise = rnorm(N)) +
  declare_potential_outcomes(Y ~ noise + Z * rnorm(N, 2, 2)) +
  declare_sampling(n = 250) +
  declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_step(dplyr::mutate, noise_sq = noise^2) +
  declare_assignment(m = 25) +
  reveal_outcomes() +
  declare_estimator(Y ~ Z, estimand = "my_estimand")

design

df <- draw_data(design)

estimates <- draw_estimates(design)
estimands <- draw_estimands(design)

print_code(design)


my_population <- declare_population(N = 100)

my_assignment <- declare_assignment(m = 50)

my_design <- my_population + my_assignment

print_code(my_design)


my_population <- declare_population(N = 500, noise = rnorm(N))

my_potential_outcomes <- declare_potential_outcomes(
  Y_Z_0 = noise, Y_Z_1 = noise +
  rnorm(N, mean = 2, sd = 2))

my_sampling <- declare_sampling(n = 250)

my_assignment <- declare_assignment(m = 25)

my_estimand <- declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0))

my_estimator <- declare_estimator(Y ~ Z, estimand = my_estimand)

my_mutate <- declare_step(dplyr::mutate, noise_sq = noise ^ 2)

my_reveal <- reveal_outcomes()

design <- my_population +
  my_potential_outcomes +
  my_sampling +
  my_estimand +
  my_mutate +
  my_assignment +
  my_reveal +
  my_estimator

summary(design)
}
