% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_try.R
\name{tidy_try}
\alias{tidy_try}
\title{Tidy Model Results and Filter to Relevant Coefficients}
\usage{
tidy_try(fit, term = FALSE)
}
\arguments{
\item{fit}{A model fit, as returned by a modeling function like lm, glm, or estimatr::lm_robust.}

\item{term}{A character vector of the terms that represent quantities of interest, i.e., "Z". If FALSE, return the first non-intercept term; if TRUE return all terms.}
}
\value{
A data.frame with coefficient estimates and associated statistics.
}
\description{
Tidy function that returns a tidy data.frame of model results and allows filtering to relevant coefficients. The function will attempt to tidy model objects even when they do not have a tidy method available. For best results, first load the broom package via \code{library(broom)}.
}
\examples{

fit <- lm(mpg ~ hp + disp + cyl, data = mtcars)

tidy_try(fit)

}
