% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_inquiry.R
\name{declare_inquiry}
\alias{declare_inquiry}
\alias{declare_inquiries}
\alias{declare_estimand}
\alias{declare_estimands}
\alias{inquiry_handler}
\title{Declare inquiry}
\usage{
declare_inquiry(..., handler = inquiry_handler, label = "inquiry")

declare_inquiries(..., handler = inquiry_handler, label = "inquiry")

declare_estimand(...)

declare_estimands(...)

inquiry_handler(data, ..., subset = NULL, term = FALSE, label)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{a data.frame}

\item{subset}{a subset expression}

\item{term}{TRUE/FALSE}
}
\value{
a function, I(), that accepts a data.frame as an argument and returns a data.frame containing the value of the inquiry,  a^m.
}
\description{
Declares inquiries, or the inferential target of interest. Conceptually very close to "estimand" or "quantity of interest".
}
\details{
For the default diagnosands, the return value of the handler should have \code{inquiry} and \code{estimand} columns.

If term is TRUE, the names of ... will be returned in a \code{term} column,
and \code{inquiry} will contain the step label. This can be used as
an additional dimension for use in diagnosis.
}
\examples{

# Set up a design for use in examples:

design <-
  declare_model(N = 100,
                X = rnorm(N),
                potential_outcomes(Y ~ (.25 + X) * Z + rnorm(N))) +
  declare_assignment(Z = complete_ra(N, m = 50)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z))

design + declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0))


design + declare_inquiry(ATT = mean(Y_Z_1 - Y_Z_0),
                         subset = (Z == 1))

# Add inquirys to a design along with estimators that reference them

design_1 <-
  design +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_estimator(Y ~ Z, inquiry = "ATE")

run_design(design_1)

# Two inquirys, one estimator

design_2 <-
  design +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_inquiry(ATT = mean(Y_Z_1 - Y_Z_0), subset = (Z == 1)) +
  declare_estimator(Y ~ Z, inquiry = c("ATE", "ATT"))

run_design(design_2)

# Two inquirys, two coefficients from one estimator

design_3 <-
  design +
  declare_inquiry(intercept = mean(Y_Z_0),
                  slope = mean(Y_Z_1 - Y_Z_0)) +
  declare_estimator(
    Y ~ Z,
    model = lm_robust,
    term = TRUE,
    inquiry = c("intercept", "slope")
  )

run_design(design_3)
}
