/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class MergeData
extends JFrame
implements ActionListener {
    private JPanel varPanel1;
    private JPanel varPanel2;
    private JCheckBox key1;
    private JList pairedList;
    private JButton mergeButton;
    private JButton useSecondary;
    private JButton usePrimary;
    private JButton pairAllButton;
    private JButton removeButton1;
    private JButton unpairButton;
    private JList mergeByList;
    private JButton useBoth;
    private JPanel mergeByPanel;
    private JPanel pairedPanel;
    private JCheckBox key2;
    private JCheckBox includeCheckBox2;
    private JCheckBox includeCheckBox1;
    private JList dataList2;
    private JList dataList1;
    private JButton pairButton;
    private JButton help;
    private static DefaultListModel mergeByListModel;
    private static DefaultListModel pairedListModel;
    private static DefaultComboBoxModel dataList1Model;
    private static DefaultComboBoxModel dataList2Model;
    private static String lastDataName1;
    private static Vector lastVarNames1;
    private static String lastDataName2;
    private static Vector lastVarNames2;
    private static String lastDataSetName;

    public MergeData(String string, String string2, String string3) {
        this.initGUI(string, string2, string3);
    }

    private void initGUI(String string, String string2, String string3) {
        try {
            boolean bl = false;
            boolean bl2 = string2.equals(lastDataName1) && string3.equals(lastDataName2);
            Vector vector = new Vector();
            vector.copyInto(Deducer.timedEval("colnames(" + string2 + ")").asStrings());
            Vector vector2 = new Vector();
            vector2.copyInto(Deducer.timedEval("colnames(" + string3 + ")").asStrings());
            if (bl2) {
                if (!vector.equals(lastVarNames1)) {
                    bl2 = false;
                }
                if (!vector2.equals(lastVarNames2)) {
                    bl2 = false;
                }
            }
            lastDataName1 = string2;
            lastDataName2 = string3;
            lastDataSetName = string;
            lastVarNames1 = vector;
            lastVarNames2 = vector2;
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.setDefaultCloseOperation(2);
            JLabel jLabel = new JLabel();
            jLabel.setText("Source:");
            this.getContentPane().add((Component)jLabel, new AnchorConstraint(525, 326, 554, 200, 1, 1, 1, 1));
            this.useBoth = new JButton();
            this.getContentPane().add((Component)this.useBoth, new AnchorConstraint(599, 326, 633, 200, 1, 1, 1, 1));
            this.useBoth.setText("[Both]");
            this.useBoth.setPreferredSize(new Dimension(86, 22));
            this.useBoth.addActionListener(this);
            this.useSecondary = new JButton();
            this.getContentPane().add((Component)this.useSecondary, new AnchorConstraint(556, 326, 590, 264, 1, 1, 1, 1));
            this.useSecondary.setText("[2]");
            this.useSecondary.setPreferredSize(new Dimension(42, 22));
            this.useSecondary.setFont(new Font("Dialog", 0, 10));
            this.useSecondary.addActionListener(this);
            this.usePrimary = new JButton();
            this.getContentPane().add((Component)this.usePrimary, new AnchorConstraint(556, 264, 590, 200, 1, 1, 1, 1));
            this.usePrimary.setText("[1]");
            this.usePrimary.setPreferredSize(new Dimension(44, 22));
            this.usePrimary.setFont(new Font("Dialog", 0, 10));
            this.usePrimary.addActionListener(this);
            this.pairAllButton = new JButton();
            this.getContentPane().add((Component)this.pairAllButton, new AnchorConstraint(230, 566, 281, 436, 1, 1, 1, 1));
            this.pairAllButton.setText("Auto-Pair");
            this.pairAllButton.setPreferredSize(new Dimension(89, 33));
            this.pairAllButton.setFont(new Font("Dialog", 0, 10));
            this.pairAllButton.addActionListener(this);
            this.removeButton1 = new JButton();
            this.getContentPane().add((Component)this.removeButton1, new AnchorConstraint(910, 326, 956, 200, 1, 1, 1, 1));
            this.removeButton1.setText("Remove");
            this.removeButton1.setPreferredSize(new Dimension(86, 23));
            this.removeButton1.addActionListener(this);
            this.unpairButton = new JButton();
            this.getContentPane().add((Component)this.unpairButton, new AnchorConstraint(722, 326, 755, 200, 1, 1, 1, 1));
            this.unpairButton.setText(" Remove ");
            this.unpairButton.setPreferredSize(new Dimension(86, 22));
            this.unpairButton.addActionListener(this);
            Serializable serializable = new OkayCancelPanel(false, true, this);
            this.getContentPane().add((Component)serializable, new AnchorConstraint(904, 990, 956, 690, 1, 1, 1, 1));
            serializable.setPreferredSize(new Dimension(77, 34));
            this.mergeByPanel = new JPanel();
            serializable = new BorderLayout();
            this.mergeByPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.mergeByPanel, new AnchorConstraint(829, 675, 956, 335, 1, 1, 1, 1));
            this.mergeByPanel.setPreferredSize(new Dimension(232, 83));
            this.mergeByPanel.setBorder(BorderFactory.createTitledBorder("Match Cases By"));
            if (mergeByListModel == null || !bl2) {
                mergeByListModel = new DefaultListModel();
            }
            this.mergeByList = new MergeDJList();
            Object object = new JScrollPane(this.mergeByList, 22, 31);
            this.mergeByPanel.add((Component)object, "Center");
            this.mergeByList.setModel(mergeByListModel);
            this.mergeButton = new IconButton("/icons/1downarrow_32.png", "Case Identifier", this, "Case Identifier");
            this.getContentPane().add((Component)this.mergeButton, new AnchorConstraint(763, 598, 820, 408, 1, 1, 1, 1));
            this.mergeButton.setPreferredSize(new Dimension(130, 32));
            this.mergeButton.setContentAreaFilled(false);
            this.pairedPanel = new JPanel();
            serializable = new BorderLayout();
            this.pairedPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.pairedPanel, new AnchorConstraint(383, 675, 763, 335, 1, 1, 1, 1));
            this.pairedPanel.setPreferredSize(new Dimension(232, 248));
            this.pairedPanel.setBorder(BorderFactory.createTitledBorder("Common Variables"));
            if (pairedListModel == null || !bl2) {
                pairedListModel = new DefaultListModel();
            }
            this.pairedList = new PairDJList();
            object = new JScrollPane(this.pairedList, 22, 31);
            this.pairedPanel.add((Component)object, "Center");
            this.pairedList.setModel(pairedListModel);
            this.key2 = new JCheckBox();
            this.getContentPane().add((Component)this.key2, new AnchorConstraint(423, 971, 457, 707, 1, 1, 1, 1));
            this.key2.setText("Unique Identifiers");
            this.key2.setPreferredSize(new Dimension(180, 22));
            this.key2.addActionListener(this);
            this.key2.setVisible(false);
            this.key1 = new JCheckBox();
            this.getContentPane().add((Component)this.key1, new AnchorConstraint(423, 258, 457, 18, 1, 1, 1, 1));
            this.key1.setText("Unique Identifiers");
            this.key1.setPreferredSize(new Dimension(164, 22));
            this.key1.addActionListener(this);
            this.key1.setVisible(false);
            this.includeCheckBox2 = new JCheckBox();
            this.getContentPane().add((Component)this.includeCheckBox2, new AnchorConstraint(392, 971, 423, 707, 1, 1, 1, 1));
            this.includeCheckBox2.setText("Drop Unmatched Cases");
            this.includeCheckBox2.setPreferredSize(new Dimension(180, 20));
            this.includeCheckBox2.addActionListener(this);
            this.includeCheckBox1 = new JCheckBox();
            this.getContentPane().add((Component)this.includeCheckBox1, new AnchorConstraint(383, 326, 414, 18, 1, 1, 1, 1));
            this.includeCheckBox1.setText("Drop Unmatched Cases");
            this.includeCheckBox1.setPreferredSize(new Dimension(210, 20));
            this.includeCheckBox1.addActionListener(this);
            this.pairButton = new IconButton("/icons/1downarrow_32.png", "Pair variables", this, "Pair");
            this.getContentPane().add((Component)this.pairButton, new AnchorConstraint(325, 566, 374, 436, 1, 1, 1, 1));
            this.pairButton.setPreferredSize(new Dimension(89, 32));
            this.pairButton.setContentAreaFilled(false);
            this.varPanel1 = new JPanel();
            serializable = new BorderLayout();
            this.getContentPane().add((Component)this.varPanel1, new AnchorConstraint(12, 427, 374, 12, 2, 1, 1, 2));
            this.varPanel1.setPreferredSize(new Dimension(279, 232));
            this.varPanel1.setLayout((LayoutManager)((Object)serializable));
            this.varPanel1.setBorder(BorderFactory.createTitledBorder("Primary Data [1]: " + string2));
            if (dataList1Model == null || !bl2) {
                object = Deducer.timedEval("colnames(" + string2 + ")").asStrings();
                dataList1Model = new DefaultComboBoxModel<String>((E[])object);
                bl = true;
            }
            this.dataList1 = new JList();
            this.dataList1.setSelectionMode(0);
            object = new JScrollPane(this.dataList1, 22, 31);
            this.varPanel1.add((Component)object, "Center");
            this.dataList1.setModel(dataList1Model);
            this.varPanel2 = new JPanel();
            this.getContentPane().add((Component)this.varPanel2, new AnchorConstraint(12, 20, 374, 584, 2, 2, 1, 1));
            serializable = new BorderLayout();
            this.varPanel2.setPreferredSize(new Dimension(264, 232));
            this.varPanel2.setBorder(BorderFactory.createTitledBorder("Secondary Data [2]: " + string3));
            this.varPanel2.setLayout((LayoutManager)((Object)serializable));
            if (dataList2Model == null || !bl2) {
                object = Deducer.timedEval("colnames(" + string3 + ")").asStrings();
                dataList2Model = new DefaultComboBoxModel<String>((E[])object);
                bl = true;
            }
            this.dataList2 = new JList();
            object = new JScrollPane(this.dataList2, 22, 31);
            this.varPanel2.add((Component)object, "Center");
            this.dataList2.setModel(dataList2Model);
            this.dataList2.setSelectionMode(0);
            this.help = new HelpButton("pmwiki.php?n=Main.MergeData");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(904, 990, 956, 12, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            if (bl) {
                this.findPairs();
            }
            this.pack();
            this.setMinimumSize(new Dimension(600, 600));
            this.setSize(720, 690);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void findPairs() {
        block0: for (int i = 0; i < this.dataList1.getModel().getSize(); ++i) {
            for (int j = 0; j < this.dataList2.getModel().getSize(); ++j) {
                if (!this.dataList1.getModel().getElementAt(i).equals(this.dataList2.getModel().getElementAt(j))) continue;
                ((DefaultListModel)this.pairedList.getModel()).addElement("[1] " + this.dataList1.getModel().getElementAt(i));
                ((DefaultComboBoxModel)this.dataList1.getModel()).removeElementAt(i);
                ((DefaultComboBoxModel)this.dataList2.getModel()).removeElementAt(j);
                --i;
                continue block0;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "Case Identifier") {
            int n;
            int[] nArray = this.pairedList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable from the common variables list to identify common cases.");
            }
            for (n = 0; n < nArray.length; ++n) {
                mergeByListModel.addElement(((String)pairedListModel.getElementAt(nArray[n])).substring(4));
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                pairedListModel.removeElementAt(nArray[n]);
            }
        } else if (string == "Remove") {
            int[] nArray = this.mergeByList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                pairedListModel.addElement("[1] " + mergeByListModel.getElementAt(nArray[i]));
                mergeByListModel.removeElementAt(nArray[i]);
            }
        } else if (string == " Remove ") {
            int[] nArray = this.pairedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                String string2 = (String)pairedListModel.getElementAt(nArray[i]);
                if (string2.indexOf("<==>") == -1) {
                    ((DefaultComboBoxModel)this.dataList2.getModel()).addElement(string2.substring(4));
                    ((DefaultComboBoxModel)this.dataList1.getModel()).addElement(string2.substring(4));
                } else {
                    String[] stringArray = string2.split("<==>");
                    ((DefaultComboBoxModel)this.dataList2.getModel()).addElement(stringArray[1]);
                    ((DefaultComboBoxModel)this.dataList1.getModel()).addElement(stringArray[0].substring(4));
                }
                pairedListModel.removeElementAt(nArray[i]);
            }
        } else if (string == "Pair") {
            String string3 = (String)this.dataList1.getSelectedValue();
            String string4 = (String)this.dataList2.getSelectedValue();
            if (string3 == null || string4 == null) {
                JOptionPane.showMessageDialog(this, "Please select one variable from each data frame to create a variable pair");
                return;
            }
            ((DefaultComboBoxModel)this.dataList1.getModel()).removeElement(string3);
            ((DefaultComboBoxModel)this.dataList2.getModel()).removeElement(string4);
            if (string3.equals(string4)) {
                pairedListModel.addElement("[1] " + string3);
            } else {
                pairedListModel.addElement("[1] " + string3 + "<==>" + string4);
            }
        } else if (string == "Auto-Pair") {
            this.findPairs();
        } else if (string == "[Both]") {
            int[] nArray = this.pairedList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable from the common variables list.\nThis will indicate that the merged dataset should contain \ntwo versions of this variable, one from the primary data and one from the secondary.");
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string5 = (String)this.pairedList.getModel().getElementAt(nArray[i]);
                pairedListModel.removeElementAt(nArray[i]);
                ((DefaultListModel)this.pairedList.getModel()).add(nArray[i], "[b] " + string5.substring(4));
            }
            this.pairedList.setSelectedIndices(nArray);
        } else if (string == "[1]") {
            int[] nArray = this.pairedList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable from the common variables list.\nThis will indicate that the merged dataset should \nuse the primary data set for this variable");
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string6 = (String)this.pairedList.getModel().getElementAt(nArray[i]);
                pairedListModel.removeElementAt(nArray[i]);
                ((DefaultListModel)this.pairedList.getModel()).add(nArray[i], "[1] " + string6.substring(4));
            }
            this.pairedList.setSelectedIndices(nArray);
        } else if (string == "[2]") {
            int[] nArray = this.pairedList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable from the common variables list.\nThis will indicate that the merged dataset should \nuse the secondary data set for this variable");
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string7 = (String)this.pairedList.getModel().getElementAt(nArray[i]);
                pairedListModel.removeElementAt(nArray[i]);
                ((DefaultListModel)this.pairedList.getModel()).add(nArray[i], "[2] " + string7.substring(4));
            }
            this.pairedList.setSelectedIndices(nArray);
        } else if (string == "Run") {
            int n;
            if (mergeByListModel.size() == 0 && (n = JOptionPane.showOptionDialog(this, "No variables have been selected to merge by.\nWould you like to merge by row names?", "Match By Row Names?", 0, 3, null, null, null)) == 1) {
                return;
            }
            n = this.merge();
            if (n != 0) {
                this.dispose();
            }
        }
    }

    public boolean merge() {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            int n;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            if (mergeByListModel.getSize() > 0) {
                string = string + "c(";
                string2 = string2 + "c(";
                for (int i = 0; i < mergeByListModel.getSize(); ++i) {
                    string4 = mergeByListModel.elementAt(i).toString();
                    if (string4.indexOf("<==>") == -1) {
                        string = string + "\"" + string4 + "\"";
                        string2 = string2 + "\"" + string4 + "\"";
                    } else {
                        stringArray2 = string4.split("<==>");
                        string = string + "\"" + stringArray2[0] + "\"";
                        string2 = string2 + "\"" + stringArray2[1] + "\"";
                    }
                    if (i >= mergeByListModel.getSize() - 1) continue;
                    string = string + ",";
                    string2 = string2 + ",";
                }
                string = string + ")";
                string2 = string2 + ")";
                stringArray = Deducer.timedEval("as.character(rownames(na.omit(" + lastDataName1 + "[" + string + "]" + "))[duplicated(na.omit(" + lastDataName1 + "[" + string + "]))])").asStrings();
                stringArray2 = Deducer.timedEval("as.character(rownames(na.omit(" + lastDataName2 + "[" + string2 + "]" + "))[duplicated(na.omit(" + lastDataName2 + "[" + string2 + "]))])").asStrings();
                if (stringArray.length > 0 && stringArray2.length > 0) {
                    int n2 = JOptionPane.showOptionDialog(this, "Niether data frame has unique case identifiers.\nMerging will create cases for every possible combination of duplicates.\nWould you like to continue?", "Duplicate Idenifiers Detected", 0, 2, null, null, null);
                    if (n2 == 1) {
                        return false;
                    }
                    Deducer.timedEval("cat('\\n')");
                    Deducer.timedEval("cat('\\nDuplicate Identifiers in " + lastDataName1 + ": " + "\\n')");
                    String string5 = "";
                    for (n = 0; n < stringArray.length; ++n) {
                        string5 = string5 + " " + stringArray[n];
                    }
                    Deducer.timedEval("cat('" + string5 + "\\n')");
                    Deducer.timedEval("cat('\\nDuplicate Identifiers in " + lastDataName2 + ": " + "\\n')");
                    string5 = "";
                    for (n = 0; n < stringArray2.length; ++n) {
                        string5 = string5 + " " + stringArray2[n];
                    }
                    Deducer.timedEval("cat('" + string5 + "\\n')");
                    Deducer.execute("", false);
                }
            } else {
                string = "\"row.names\"";
                string2 = "\"row.names\"";
            }
            stringArray = new ArrayList();
            stringArray2 = new ArrayList();
            String[] stringArray3 = new String[]{"", ""};
            n = pairedListModel.getSize();
            for (int i = 0; i < n; ++i) {
                string4 = (String)pairedListModel.getElementAt(i);
                char c = string4.charAt(1);
                if ((string4 = string4.substring(4)).indexOf("<==>") == -1) {
                    stringArray3[0] = string4;
                    stringArray3[1] = string4;
                } else {
                    stringArray3 = string4.split("<==>");
                }
                if (c == '1') {
                    stringArray2.add(stringArray3[1]);
                    continue;
                }
                if (c != '2') continue;
                stringArray.add(stringArray3[0]);
            }
            String string6 = Deducer.getUniqueName(lastDataName1 + ".temp");
            String string7 = Deducer.getUniqueName(lastDataName2 + ".temp");
            string3 = string3 + string6 + "<-" + lastDataName1 + "[setdiff(colnames(" + lastDataName1 + ")," + this.makeRStringVector((ArrayList)stringArray) + ")]";
            string3 = string3 + "\n" + string7 + "<-" + lastDataName2 + "[setdiff(colnames(" + lastDataName2 + ")," + this.makeRStringVector((ArrayList)stringArray2) + ")]";
            string3 = string3 + "\n" + lastDataSetName + "<-merge(" + string6 + "," + string7 + ",by.x=" + string + ",by.y=" + string2 + ",incomparables = NA" + ",all.x =" + (!this.includeCheckBox1.getModel().isSelected() ? "T" : "F") + ",all.y =" + (!this.includeCheckBox2.getModel().isSelected() ? "T" : "F") + ")";
            string3 = string3 + "\n" + "rm(list=c(\"" + string6 + "\",\"" + string7 + "\"))";
            Deducer.execute(string3);
            Deducer.setRecentData(lastDataSetName);
            return true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return false;
        }
    }

    public String makeRStringVector(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return "c()";
        }
        String string = "c(";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + "\"" + arrayList.get(i).toString() + "\"";
            if (i >= arrayList.size() - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    private class MergeDJList
    extends DJList {
        private MergeDJList() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            int n = this.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getModel().getElementAt(i);
                if (!string.startsWith("[")) continue;
                ((DefaultListModel)this.getModel()).removeElementAt(i);
                ((DefaultListModel)this.getModel()).add(i, string.substring(4));
            }
        }
    }

    private class PairDJList
    extends DJList {
        private PairDJList() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            int n = this.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getModel().getElementAt(i);
                if (string.startsWith("[")) continue;
                ((DefaultListModel)this.getModel()).removeElementAt(i);
                ((DefaultListModel)this.getModel()).add(i, "[1] " + string);
            }
        }
    }
}

