/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMBuilder;
import org.rosuda.deducer.models.GLMDialog;
import org.rosuda.deducer.models.GLMExplorerExport;
import org.rosuda.deducer.models.GLMExplorerMeans;
import org.rosuda.deducer.models.GLMExplorerOptions;
import org.rosuda.deducer.models.GLMExplorerPlots;
import org.rosuda.deducer.models.GLMExplorerPostHoc;
import org.rosuda.deducer.models.GLMExplorerTests;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.ModelExplorer;
import org.rosuda.deducer.models.ModelPlotPanel;
import org.rosuda.deducer.models.RModel;
import org.rosuda.deducer.toolkit.IconButton;

public class GLMExplorer
extends ModelExplorer
implements WindowListener {
    protected GLMModel model = new GLMModel();
    protected RModel pre;
    protected ModelPlotPanel diagnosticTab;
    protected ModelPlotPanel termTab;
    protected ModelPlotPanel addedTab;
    protected IconButton assumpHomo;
    protected IconButton assumpFunc;
    protected IconButton assumpN;

    GLMExplorer(GLMModel gLMModel) {
        this.setTitle("Generalized Linear Model Explorer");
        this.help.setUrl("pmwiki.php?n=Main.GeneralizedLinearModel");
        this.setModel(gLMModel);
        this.initTabs();
        this.initAssumptions();
        this.addWindowListener(this);
    }

    public void initTabs() {
        try {
            String string = "par(mfrow = c(2, 3),mar=c(5,4,2,2))\nhist(resid(" + this.pre.modelName + "),main=\"Residual\",xlab=\"Residuals\")\n" + "plot(" + this.pre.modelName + ",2,sub.caption=\"\")\n" + "plot(" + this.pre.modelName + ", c(1,4,3,5),sub.caption=\"\")";
            this.diagnosticTab = new ModelPlotPanel(string);
            this.tabs.addTab("Diagnostics", this.diagnosticTab);
            string = "par(mar=c(5,4,2,2))\ntry(cr.plots(" + this.pre.modelName + ",one.page=T,ask=F,identify.points=F,col=1),silent=TRUE)";
            this.termTab = new ModelPlotPanel(string);
            if (Deducer.rniEval("length(grep(\":\",c(attr(terms(" + this.pre.modelName + "),\"term.labels\"))))==0").asBool().isTRUE()) {
                this.tabs.addTab("Terms", this.termTab);
            }
            string = "par(mar=c(5,4,2,2))\ntry(av.plots(" + this.pre.modelName + ",one.page=T,ask=F,identify.points=F,col=1),silent=TRUE)";
            this.addedTab = new ModelPlotPanel(string);
            this.tabs.addTab("Added Variable", this.addedTab);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    protected void initAssumptions() {
        this.assumpN = new IconButton("/icons/N_assump.png", "Large Sample", null, "Large Sample");
        this.topPanel.add(this.assumpN);
        this.assumpN.setBounds(12, 8, 27, 27);
        this.assumpFunc = new IconButton("/icons/func_assump.png", "Correct Functional Form", null, "Correct Functional Form");
        this.topPanel.add(this.assumpFunc);
        this.assumpFunc.setBounds(44, 8, 27, 27);
        this.assumpHomo = new IconButton("/icons/outlier_assump.png", "No Outliers", null, "No Outliers");
        this.topPanel.add(this.assumpHomo);
        this.assumpHomo.setBounds(76, 8, 27, 27);
    }

    public void setModel(GLMModel gLMModel) {
        this.model = gLMModel;
        this.pre = this.model.run(true, this.pre);
        this.modelFormula.setText(this.pre.formula);
        this.preview.setText(this.pre.preview);
        this.preview.setCaretPosition(0);
    }

    public void run() {
        this.model.run(false, this.pre);
        this.dispose();
        GLMDialog.setLastModel(this.model);
        Deducer.rniEval("rm('" + this.pre.data.split("\\$")[1] + "','" + this.pre.modelName.split("\\$")[1] + "',envir=" + Deducer.guiEnv + ")");
    }

    public void updateClicked() {
        GLMBuilder gLMBuilder = new GLMBuilder(this.model);
        gLMBuilder.setLocationRelativeTo(this);
        gLMBuilder.setVisible(true);
        WindowTracker.addWindow(gLMBuilder);
        this.dispose();
    }

    public void optionsClicked() {
        GLMExplorerOptions gLMExplorerOptions = new GLMExplorerOptions(this, this.model);
        gLMExplorerOptions.setLocationRelativeTo(this);
        gLMExplorerOptions.setVisible(true);
        this.setModel(this.model);
    }

    public void postHocClicked() {
        GLMExplorerPostHoc gLMExplorerPostHoc = new GLMExplorerPostHoc(this, this.model, this.pre);
        gLMExplorerPostHoc.setLocationRelativeTo(this);
        gLMExplorerPostHoc.setVisible(true);
        this.setModel(this.model);
    }

    public void exportClicked() {
        GLMExplorerExport gLMExplorerExport = new GLMExplorerExport(this, this.model);
        gLMExplorerExport.setLocationRelativeTo(this);
        gLMExplorerExport.setVisible(true);
    }

    public void meansClicked() {
        GLMExplorerMeans gLMExplorerMeans = new GLMExplorerMeans(this, this.model, this.pre);
        gLMExplorerMeans.setLocationRelativeTo(this);
        gLMExplorerMeans.setVisible(true);
        this.setModel(this.model);
    }

    public void plotsClicked() {
        GLMExplorerPlots gLMExplorerPlots = new GLMExplorerPlots(this, this.model, this.pre);
        gLMExplorerPlots.setLocationRelativeTo(this);
        gLMExplorerPlots.setVisible(true);
        this.setModel(this.model);
    }

    public void testsClicked() {
        String[] stringArray = Deducer.rniEval("names(coef(" + this.pre.modelName + "))").asStringArray();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        GLMExplorerTests gLMExplorerTests = new GLMExplorerTests(this, vector, this.model);
        gLMExplorerTests.setLocationRelativeTo(this);
        gLMExplorerTests.setVisible(true);
        this.setModel(this.model);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.diagnosticTab != null) {
            this.diagnosticTab.executeDevOff();
        }
        if (this.termTab != null) {
            this.termTab.executeDevOff();
        }
        if (this.addedTab != null) {
            this.addedTab.executeDevOff();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

