/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.REngine.REXP;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.widgets.DeducerWidget;

public class RDialog
extends JDialog {
    protected Vector widgets;
    private Vector components;
    private OkayCancelPanel okayCancelPanel;
    private HelpButton helpButton;
    protected static RDialog theDialog;

    public RDialog() {
        this.initGUI();
    }

    public RDialog(Dialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public RDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
        this.initGUI();
    }

    public RDialog(Frame frame) {
        super(frame);
        this.initGUI();
    }

    public RDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initGUI();
    }

    public RDialog(Frame frame, String string) {
        super(frame, string);
        this.initGUI();
    }

    public RDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initGUI();
    }

    public RDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.initGUI();
    }

    public Component add(Component component) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.widgets.add(component);
        } else {
            this.components.add(component);
        }
        return super.add(component);
    }

    public Component add(Component component, int n) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.widgets.add(component);
        } else {
            this.components.add(component);
        }
        return super.add(component, n);
    }

    public void add(Component component, Object object) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.widgets.add(component);
        } else {
            this.components.add(component);
        }
        super.add(component, object);
    }

    public void add(Component component, Object object, int n) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.widgets.add(component);
        } else {
            this.components.add(component);
        }
        super.add(component, object, n);
    }

    public Component add(String string, Component component) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.widgets.add(component);
        } else {
            this.components.add(component);
        }
        return super.add(string, component);
    }

    public void remove(Component component) {
        int n;
        super.remove(component);
        for (n = 0; n < this.components.size(); ++n) {
            if (component != this.components.get(n)) continue;
            this.components.remove(n);
        }
        for (n = 0; n < this.widgets.size(); ++n) {
            if (component != this.widgets.get(n)) continue;
            this.widgets.remove(n);
        }
    }

    public void remove(int n) {
        int n2;
        Component component = this.getComponent(n);
        for (n2 = 0; n2 < this.components.size(); ++n2) {
            if (component != this.components.get(n2)) continue;
            this.components.remove(n2);
        }
        for (n2 = 0; n2 < this.widgets.size(); ++n2) {
            if (component != this.widgets.get(n2)) continue;
            this.widgets.remove(n2);
        }
        super.remove(n);
    }

    public void removeAll() {
        super.removeAll();
        this.components.removeAllElements();
        this.widgets.removeAllElements();
    }

    public void initGUI() {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setSize(555, 645);
    }

    public void addHelpButton(String string) {
        if (this.helpButton != null) {
            this.remove(this.helpButton);
        }
        this.helpButton = new HelpButton(string);
        this.add((Component)this.helpButton, new AnchorConstraint(940, 77, 980, 23, 0, 0, 1, 1));
        this.helpButton.setPreferredSize(new Dimension(32, 32));
    }

    public void setOkayCancel(boolean bl, boolean bl2, ActionListener actionListener) {
        if (this.okayCancelPanel != null) {
            this.remove(this.okayCancelPanel);
        }
        OkayCancelPanel okayCancelPanel = new OkayCancelPanel(bl, bl2, actionListener);
        this.add((Component)okayCancelPanel, new AnchorConstraint(926, 978, 980, 402, 0, 1, 1, 0));
        okayCancelPanel.setPreferredSize(new Dimension(307, 32));
    }

    public void setToLast() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ((DeducerWidget)this.widgets.get(i)).resetToLast();
        }
    }

    public void reset() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ((DeducerWidget)this.widgets.get(i)).reset();
        }
    }

    public void completed() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
            deducerWidget.setLastModel(deducerWidget.getModel());
        }
    }

    public void setHelpWikiPage(String string) {
        this.helpButton.setUrl(string);
    }

    public void setHelpVisible(boolean bl) {
        this.helpButton.setVisible(bl);
    }

    public void setOkayCancelVisible(boolean bl) {
        this.okayCancelPanel.setVisible(bl);
    }

    public String getWidgetStatesAsString() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.widgets.size(); ++i) {
            DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
            vector.add("\n'" + deducerWidget.getTitle() + "'=" + deducerWidget.getRModel());
        }
        String string = Deducer.makeRCollection(vector, "list", false);
        return string;
    }

    public REXP getWidgetStates() {
        return Deducer.eval(this.getWidgetStatesAsString());
    }

    public void run() {
        this.setToLast();
        this.setVisible(true);
        WindowTracker.addWindow(this);
    }
}

