% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{subLines}
\alias{subLines}
\title{Plot weights as lines}
\usage{
subLines(sub.parts, range, axis.above = TRUE, axis.below = TRUE)
}
\arguments{
\item{sub.parts}{a list of \link{DLData} objects}

\item{range}{the range of values shown in the plot (i.e., the \code{xlim}
value of the call to \link[graphics]{plot})}

\item{axis.above}{if \code{TRUE}, an axis at the top of the plot (side=3) is shown}

\item{axis.below}{if \code{TRUE}, an axis at the bottom of the plot (side=1) is shown}
}
\description{
Plots a representation of the weights of a list of \link{DLData} objects.
Each entry of the list is shown as an independent line with the median value
shown as a red vertical line. Plots of list entries are separated by
horizontal grey lines.
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "nrsf.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )

# create dependency logo with plotted weights
plotDeplogo(data, threshold = 0.03, weight.fun = subLines)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
