% Generated by roxygen2 (4.0.2): do not edit by hand
\name{depthTukey}
\alias{depthTukey}
\title{Tukey Depth}
\usage{
depthTukey(u, X, ndir = 1000, name = "X", threads = -1, exact = FALSE,
  ...)
}
\arguments{
\item{u}{Numerical vector or matrix whose depth is to be calculated. Dimension has to be the same as that of the observations.}

\item{X}{The data as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation. If it is a list, all components must be numerical vectors of equal length (coordinates of observations).}

\item{ndir}{number of directions used in computations}

\item{name}{name for this data set - it will be used on plots from depthproc.}

\item{threads}{number of threads used in parallel computations. Default value -1 means that all possible cores will be used.}

\item{exact}{if TRUE exact alhorithm will be used . Currently it works only for 2 dimensional data set.}

\item{\dots}{currently not supported.}
}
\description{
Computes the Tukey depth of a point or vectors of points with respect to a multivariate data set.
}
\details{
Irrespective of dimension, Projection and Tukey's depth is obtained by approximate calculation.

 Returns the depth of multivariate point \code{u} with respect to data set \code{X}.
}
\examples{
\dontrun{
 x = matrix(rnorm(3000), nc = 3)
 depthTukey(x, ndir = 2000)
 }

 # Exact algorithm in 2d
 x = matrix(rnorm(2000), nc = 2)
 depthTukey(x, exact = TRUE)
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}

