#' DescrTab2
#' @description Publication quality descriptive statistics tables with R
#'
#' @details Provides functions to create descriptive statistics tables for continuous and categorical variables.
#' By default, summary statistics such as mean, standard deviation, quantiles, minimum and maximum for continuous
#' variables and relative and absolute frequencies for categorical variables are calculated. 'DescrTab2' features a sophisticated algorithm to
#' choose appropriate test statistics for your data and provides p-values. On top of this, confidence intervals for group
#' differences of appropriated summary measures are automatically produces for two-group comparison.
#' Tables generated by 'DescrTab2' can be integrated in a variety of document formats, including .html, .tex and .docx documents.
#' 'DescrTab2' also allows printing tables to console and saving table objects for later use.
#'
#' Check out our documentation online: https://imbi-heidelberg.github.io/DescrTab2/
#' or browse the help files in the Rstudio viewer. You can access the vignettes by typing: \code{browseVignettes("DescrTab2")}
#'
#' The most important function you probably want to check out is called \code{\link{descr}}.
#'
#' @docType package
#' @name DescrTab2
NULL

# nocov start
#' Load LaTeX packages
#'
#' @param libname library name
#' @param pkgname package name
#' @details Thanks to Hao Zhu and his package \link[kableExtra]{kableExtra}.
#' @author Hao Zhu
#' @importFrom kableExtra usepackage_latex
.onLoad <- function(libname = find.package("kableExtra"), pkgname = "kableExtra") {
  if (knitr::is_latex_output()) {
    load_packages <- getOption("kableExtra.latex.load_packages", default = TRUE)
    if (load_packages) {
      usepackage_latex("booktabs")
      usepackage_latex("longtable")
      usepackage_latex("array")
      usepackage_latex("multirow")
      usepackage_latex("wrapfig")
      usepackage_latex("float")
      usepackage_latex("colortbl")
      usepackage_latex("pdflscape")
      usepackage_latex("tabu")
      usepackage_latex("threeparttable")
      usepackage_latex("threeparttablex")
      usepackage_latex("ulem", "normalem")
      usepackage_latex("makecell")
      usepackage_latex("xcolor")
      usepackage_latex("needspace")
      usepackage_latex("setspace")
    }
  }
}
# nocov end
