% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_arm_covariate_designer.R
\name{two_arm_covariate_designer}
\alias{two_arm_covariate_designer}
\title{Create a simple two arm design with a possibly prognostic covariate}
\usage{
two_arm_covariate_designer(N = 100, prob = 0.5, control_mean = 0,
  sd = 1, ate = 1, h = 0, treatment_mean = control_mean + ate,
  rho_WY = 0, rho_WZ = 0, args_to_fix = NULL)
}
\arguments{
\item{N}{An integer. Sample size.}

\item{prob}{A number in [0,1]. Probability of assignment to treatment.}

\item{control_mean}{A number. Average outcome in control.}

\item{sd}{A positive number. Standard deviation of shock on Y.}

\item{ate}{A number. Average treatment effect.}

\item{h}{A number. Controls heterogeneous treatment effects by W. Defaults to 0.}

\item{treatment_mean}{A number. Average outcome in treatment. Overrides \code{ate} if both specified.}

\item{rho_WY}{A number in [-1,1]. Correlation between W and Y.}

\item{rho_WZ}{A number in [-1,1]. Correlation between W and Z.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A simple two-arm design with covariate W.
}
\description{
Builds a design with one treatment and one control arm.
Treatment effects can be specified either by providing \code{control_mean} and \code{treatment_mean}
or by specifying a \code{control_mean} and \code{ate}.
Non random assignment is specified by a possible correlation, \code{rho_WZ},  between \code{W} and a latent variable that determines the probability of \code{Z}.  
Nonignorability is specified by a possible correlation, \code{rho_WY},  between \code{W} and outcome \code{Y}.
}
\details{
Units are assigned to treatment using complete random assignment. Potential outcomes are normally distributed according to the mean and sd arguments.

See \href{https://declaredesign.org/library/articles/simple_two_arm.html}{vignette online}.
}
\examples{
#Generate a simple two-arm design using default arguments
two_arm_covariate_design <- two_arm_covariate_designer()
# Design with no confounding but a prognostic covariate 
prognostic <- two_arm_covariate_designer(N = 40, ate = .2, rho_WY = .9, h = .5)
\dontrun{
diagnose_design(prognostic)
}
# Design with confounding 
confounding <- two_arm_covariate_designer(N = 40, ate = 0, rho_WZ = .9, rho_WY = .9, h = .5)
\dontrun{
diagnose_design(confounding, sims = 2000)
}

# Curse of power: A biased design may be more likely to mislead the larger it is 
curses <- expand_design(two_arm_covariate_designer, 
                        N = c(50, 500, 5000), ate = 0, rho_WZ = .2, rho_WY = .2)
\dontrun{
diagnoses <- diagnose_design(curses)
subset(diagnoses$diagnosands_df, estimator_label == "No controls")[,c("N", "power")]
}
}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
