% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_w_connected_cmpts.R
\name{count_w_connected_cmpts}
\alias{count_w_connected_cmpts}
\title{Get the number of weakly-connected components}
\usage{
count_w_connected_cmpts(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single integer value representing the
number of weakly-connected graph components.
}
\description{
Get the number of weakly-connected
components in the graph.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5) \%>\%
  add_cycle(n = 5)

# Get a count of weakly-connected
# components in the graph
graph \%>\%
  count_w_connected_cmpts()
}
