% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_loop_edges_ws.R
\name{delete_loop_edges_ws}
\alias{delete_loop_edges_ws}
\title{Delete all loop edges associated with a selection of nodes}
\usage{
delete_loop_edges_ws(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
With a selection of nodes in a
graph, remove any associated loop edges.
}
\examples{
# Create an undirected, full graph
# of 5 nodes with loops retained
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_full_graph(
    n = 5,
    keep_loops = TRUE)

# Select nodes `3` and `4`
# and remove the loop edges
# associated with those nodes
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = 3:4) \%>\%
  delete_loop_edges_ws()

# Count the number of loop
# edges remaining in the graph
graph \%>\%
  count_loop_edges()
}
