% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fully_disconnect_nodes_ws.R
\name{fully_disconnect_nodes_ws}
\alias{fully_disconnect_nodes_ws}
\title{Fully disconnect all nodes in a selection of nodes}
\usage{
fully_disconnect_nodes_ws(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
With a selection of nodes in a
graph, remove any edges to or from those nodes.
}
\examples{
# Create an empty graph and
# add a path of 6 nodes
graph <-
  create_graph() \%>\%
  add_path(n = 6)

# Select nodes `3` and `4`
# and fully disconnect them
# from the graph
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = 3:4) \%>\%
  fully_disconnect_nodes_ws()

# Get the graph's edge data frame
graph \%>\%
  get_edge_df()
}
