% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agg_degree_out.R
\name{get_agg_degree_out}
\alias{get_agg_degree_out}
\title{Get an aggregate value from the outdegree of nodes}
\usage{
get_agg_degree_out(graph, agg, conditions = NULL)
}
\arguments{
\item{graph}{a graph object of
class \code{dgr_graph}.}

\item{agg}{the aggregation
function to use for summarizing
outdegree values from graph nodes.
The following aggregation functions
can be used: \code{sum}, \code{min},
\code{max}, \code{mean}, or \code{median}.}

\item{conditions}{an option to
use filtering conditions for
the nodes to consider.}
}
\value{
a vector with an aggregate
outdegree value.
}
\description{
Get a single,
aggregate value from the
outdegree values for all nodes
in a graph, or, a subset
of graph nodes.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 20,
    m = 35,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the mean outdegree value from all
# nodes in the graph
graph \%>\%
  get_agg_degree_out(
    agg = "mean")

# Other aggregation functions can be used
# (`min`, `max`, `median`, `sum`); let's
# get the median in this example
graph \%>\%
  get_agg_degree_out(
    agg = "median")

# The aggregation of outdegree can occur
# for a subset of the graph nodes and this
# is made possible by specifying `conditions`
# for the nodes
graph \%>\%
  get_agg_degree_out(
    agg = "mean",
    conditions = value < 5.0)
}
