% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_edge_present.R
\name{is_edge_present}
\alias{is_edge_present}
\title{Determine whether a specified edge is present}
\usage{
is_edge_present(graph, edge = NULL, from = NULL, to = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge}{an edge ID value to test for
presence in the graph. If a single, numeric
value is provided then values for \code{from}
or \code{to} needn't be supplied.}

\item{from}{a node ID from which the edge
is outgoing, or, the label associated with
the node. For an undirected graph, the
value in \code{from} can be interchangeable
with that in \code{to}.}

\item{to}{a node ID to which the edge is
incoming, or, the label associated with
the node. For an undirected graph, the
value in \code{to} can be interchangeable
with that in \code{from}.}
}
\value{
a logical value.
}
\description{
From a graph object of class
\code{dgr_graph}, determine whether an edge
(defined by a pair of node IDs or node label
values) is present.
}
\examples{
# Create a simple graph with
# a path of four nodes
graph <-
  create_graph() \%>\%
  add_path(
    n = 4,
    type = "path",
    label = c("one", "two",
              "three", "four"))

# Find out if edge ID `3`
# is present in the graph
graph \%>\%
  is_edge_present(edge = 3)

# Determine if there are any edges
# with the definition `1` -> `2`
graph \%>\%
  is_edge_present(
    from = 1,
    to = 2)

# Determine if there are any edges
# with the definition `4` -> `5`
graph \%>\%
  is_edge_present(
    from = 4,
    to = 5)

# Determine whether an edge,
# defined by its labels as
# `two` -> `three`, exists in
# the graph
graph \%>\%
  is_edge_present(
    from = "two",
    to = "three")

# Set the graph as undirected
# and determine whether an
# edge between nodes with labels
# `three` and `two` exists
graph \%>\%
  set_graph_undirected() \%>\%
  is_edge_present(
    from = "three",
    to = "two")
}
