% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_df_as_node_attr.R
\name{set_df_as_node_attr}
\alias{set_df_as_node_attr}
\title{Set a data frame as a node attribute}
\usage{
set_df_as_node_attr(graph, node, df)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node}{The node ID to which the data frame will be bound as an
attribute.}

\item{df}{The data frame to be bound to the node as an attribute.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, bind a data frame as a node
attribute property for one given graph node. The data frames are stored in
list columns within a \code{df_tbl} object. A \code{df_id} value is generated and
serves as a pointer to the table row that contains the ingested data frame.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Create a simple data frame to add as
# a node attribute
df <-
  data.frame(
    a = c("one", "two", "three"),
    b = c(1, 2, 3),
    stringsAsFactors = FALSE)

# Bind the data frame as a node attribute
# of node `1`
graph <-
  graph \%>\%
  set_df_as_node_attr(
    node = 1,
    df = df)

# Create another data frame to add as
# a node attribute
df_2 <-
  data.frame(
    c = c("four", "five", "six"),
    d = c(4, 5, 6),
    stringsAsFactors = FALSE)

# Bind the data frame as a node attribute
# of node `2`
graph <-
  graph \%>\%
  set_df_as_node_attr(
    node = 2,
    df = df_2)

}
