% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nudge_node_positions_ws.R
\name{nudge_node_positions_ws}
\alias{nudge_node_positions_ws}
\title{Move layout positions of a selection of nodes}
\usage{
nudge_node_positions_ws(graph, dx, dy)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{dx}{A single numeric value specifying the amount that selected nodes
(with non-\code{NA} values for the \code{x} and \code{y} attributes) will be moved in the
x direction. A positive value will move nodes right, negative left.}

\item{dy}{A single numeric value specifying the amount that selected nodes
(with non-\code{NA} values for the \code{x} and \code{y} attributes) will be moved in the
y direction. A positive value will move nodes up, negative down.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With an active selection of nodes, move the position in either the \code{x} or \code{y}
directions, or both. Nodes in the selection that do not have position
information (i.e., \code{NA} values for the \code{x} or \code{y} node attributes) will be
ignored.
}
\details{
This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create a simple graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(
    type = "a",
    label = "one") \%>\%
  add_node(
    type = "a",
    label = "two") \%>\%
  add_node(
    type = "b",
    label = "three") \%>\%
  add_node(
    type = "b",
    label = "four")

# Add position information to each of
# the graph's nodes
graph <-
  graph \%>\%
  set_node_position(
    node = 1, x = 1, y = 1) \%>\%
  set_node_position(
    node = 2, x = 2, y = 2) \%>\%
  set_node_position(
    node = 3, x = 3, y = 3) \%>\%
  set_node_position(
    node = 4, x = 4, y = 4)

# Select all of the graph's nodes using the
# `select_nodes()` function (and only
# specifying the graph object)
graph <- select_nodes(graph)

# Move the selected nodes (all the nodes,
# in this case) 5 units to the right
graph <-
  graph \%>\%
  nudge_node_positions_ws(
    dx = 5, dy = 0)

# View the graph's node data frame
graph \%>\% get_node_df()

# Now select nodes that have `type == "b"`
# and move them in the `y` direction 2 units
# (the graph still has an active selection
# and so it must be cleared first)
graph <-
  graph \%>\%
  clear_selection() \%>\%
  select_nodes(
    conditions = type == "b") \%>\%
  nudge_node_positions_ws(
    dx = 0, dy = 2)

# View the graph's node data frame
graph \%>\% get_node_df()

}
