% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Griffing.R
\name{Griffing}
\alias{Griffing}
\title{Diallel Analysis using Griffing Approach}
\usage{
Griffing(y, Rep, Cross1, Cross2, data, Method, Model)
}
\arguments{
\item{y}{Numeric Response Vector}

\item{Rep}{Replicate as factor}

\item{Cross1}{Cross 1 as factor}

\item{Cross2}{Cross 2 as factor}

\item{data}{A \code{data.frame}}

\item{Method}{Method for Diallel Analysis using Griffing's approach.
It can take \strong{1}, \strong{2}, \strong{3}, or \strong{4}
 as argument depending on the method being used.
\enumerate{
\item Method-I (Parents + \eqn{F_{1}}'s + reciprocals);
\item Method-II (Parents and one set of \eqn{F_{1}}'s);
\item Method-III (One set of \eqn{F_{1}}'s and reciprocals);
\item Method-IV (One set of \eqn{F_{1}}'s only).
}}

\item{Model}{Model for Diallel Analysis using Griffing's approach.
It can take \strong{1} or \strong{2} as arguments depending on the model being used.
\enumerate{
\item Fixed  Effects Model;
\item Random Effects Model.
}}
}
\value{
Means Means

ANOVA Analysis of Variance (ANOVA) table

Genetic.Components Genetic Components

Effects Effects of Crosses

StdErr Standard Errors of Crosses
}
\description{
\code{Griffing} is used for performing Diallel Analysis using Griffing's Approach.
}
\details{
Diallel Analysis using Griffing's approach.
}
\examples{
#-------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 1 & Model 1
#-------------------------------------------------------------
Griffing1Data1 <-
 Griffing(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = GriffingData1
   , Method = 1
   , Model  = 1
 )
names(Griffing1Data1)
Griffing1Data1
Griffing1Data1Means <- Griffing1Data1$Means
Griffing1Data1ANOVA <- Griffing1Data1$ANOVA
Griffing1Data1Genetic.Components <- Griffing1Data1$Genetic.Components
Griffing1Data1Effects <- Griffing1Data1$Effects
Griffing1Data1StdErr <- as.matrix(Griffing1Data1$StdErr)


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 1 & Model 2
#--------------------------------------------------------------
Griffing2Data1 <-
 Griffing(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = GriffingData1
   , Method = 1
   , Model  = 2
 )
names(Griffing2Data1)
Griffing2Data1
Griffing2Data1Means <- Griffing2Data1$Means
Griffing2Data1ANOVA <- Griffing2Data1$ANOVA
Griffing2Data1Genetic.Components <- Griffing2Data1$Genetic.Components


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 2 & Model 1
#--------------------------------------------------------------
Griffing1Data2 <-
 Griffing(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = GriffingData2
   , Method = 2
   , Model  = 1
 )
names(Griffing1Data2)
Griffing1Data2
Griffing1Data2Means <- Griffing1Data2$Means
Griffing1Data2ANOVA <- Griffing1Data2$ANOVA
Griffing1Data2Genetic.Components <- Griffing1Data2$Genetic.Components
Griffing1Data2Effects <- Griffing1Data2$Effects
Griffing1Data2StdErr <- as.matrix(Griffing1Data2$StdErr)


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 2 & Model 2
#--------------------------------------------------------------
Griffing2Data2 <-
 Griffing(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = GriffingData2
   , Method = 2
   , Model  = 2
 )
names(Griffing2Data2)
Griffing2Data2
Griffing2Data2Means <- Griffing2Data2$Means
Griffing2Data2ANOVA <- Griffing2Data2$ANOVA
Griffing2Data2Genetic.Components <- Griffing2Data2$Genetic.Components


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 3 & Model 1
#--------------------------------------------------------------
Griffing1Data3 <-
 Griffing(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = GriffingData3
   , Method = 3
   , Model  = 1
 )
names(Griffing1Data3)
Griffing1Data3
Griffing1Data3Means <- Griffing1Data3$Means
Griffing1Data3ANOVA <- Griffing1Data3$ANOVA
Griffing1Data3Genetic.Components <- Griffing1Data3$Genetic.Components
Griffing1Data3Effects <- Griffing1Data3$Effects
Griffing1Data3StdErr <- as.matrix(Griffing1Data3$StdErr)


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 3 & Model 2
#--------------------------------------------------------------
Griffing2Data3 <-
 Griffing(
     y       = Yield
   , Rep     = Rep
   , Cross1  = Cross1
   , Cross2  = Cross2
   , data    = GriffingData3
   , Method  = 3
   , Model   = 2
 )
names(Griffing2Data3)
Griffing2Data3
Griffing2Data3Means <- Griffing2Data3$Means
Griffing2Data3ANOVA <- Griffing2Data3$ANOVA
Griffing2Data3Genetic.Components <- Griffing2Data3$Genetic.Components


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 4 & Model 1
#--------------------------------------------------------------
Griffing1Data4 <-
 Griffing(
     y       = Yield
   , Rep     = Rep
   , Cross1  = Cross1
   , Cross2  = Cross2
   , data    = GriffingData4
   , Method  = 4
   , Model   = 1
 )
names(Griffing1Data4)
Griffing1Data4
Griffing1Data4Means <- Griffing1Data4$Means
Griffing1Data4ANOVA <- Griffing1Data4$ANOVA
Griffing1Data4Genetic.Components <- Griffing1Data4$Genetic.Components
Griffing1Data4Effects <- Griffing1Data4$Effects
Griffing1Data4StdErr <- as.matrix(Griffing1Data4$StdErr)


#--------------------------------------------------------------
## Diallel Analysis with Griffing's Aproach Method 4 & Model 2
#--------------------------------------------------------------
Griffing2Data4 <-
 Griffing(
     y       = Yield
   , Rep     = Rep
   , Cross1  = Cross1
   , Cross2  = Cross2
   , data    = GriffingData4
   , Method  = 4
   , Model   = 2
 )
names(Griffing2Data4)
Griffing2Data4
Griffing2Data4Means <- Griffing2Data4$Means
Griffing2Data4ANOVA <- Griffing2Data4$ANOVA
Griffing2Data4Genetic.Components <- Griffing2Data4$Genetic.Components
}
\references{
\enumerate{
\item Griffing, B. (1956) Concept of General and Specific Combining Ability
            in relation to Diallel Crossing Systems. \emph{Australian Journal of Biological Sciences},
             \strong{9(4)}, 463--493.
\item Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
 }
}
\seealso{
\code{\link{Hayman}}
 , \code{\link{GriffingData1}}
 , \code{\link{GriffingData2}}
 , \code{\link{GriffingData3}}
 , \code{\link{GriffingData4}}
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
