% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{sectionview3d}
\alias{sectionview3d}
\title{Plot a 3-D (using RGL) view of a kriging or modelPredict model, including design points}
\usage{
sectionview3d(model, ...)
}
\arguments{
\item{model}{an object of class \code{"km"}, a list that can be used in a \code{"modelPredict"} call, or a function.}

\item{...}{other arguments of the \code{contourview.km}, \code{contourview.list} or \code{contourview.function} function}
}
\description{
Plot a 3-D view of a kriging or modelPredict model. It is useful for a better understanding of a model behaviour.
}
\examples{
## A 2D example - Branin-Hoo function
## a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- expand.grid(seq(0, 1, length = 4), seq(0, 1, length = 4))
design.fact <- data.frame(design.fact); names(design.fact) <- c("x1", "x2")
y <- branin(design.fact)

## kriging model 1 : matern5_2 covariance structure, no trend, no nugget effect
m1 <- km(design = design.fact, response = y)

if (identical(Sys.getenv("NOT_CRAN"), "true")) { # too long for CRAN on Windows
  sectionview3d(m1)
  sectionview3d(branin, dim = 2, add=TRUE)
}
}
