% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{mesh}
\alias{mesh}
\title{Builds a mesh from a design aor set of points}
\usage{
mesh(intervals, mesh.type = "seq", mesh.sizes = 11)
}
\arguments{
\item{intervals}{bounds to inverse in, each column contains min and max of each dimension}

\item{mesh.type}{function or "unif" or "seq" (default) or "LHS" to preform interval partition}

\item{mesh.sizes}{number of parts for mesh (duplicate for each dimension if using "seq")}
}
\value{
delaunay mesh (list(p,tri,...) from geometry)
}
\description{
Builds a mesh from a design aor set of points
}
\examples{
mesh = mesh(intervals=matrix(c(0,1,0,1),ncol=2),mesh.type="unif",mesh.sizes=10)
plot2d_mesh(mesh)
}
