% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{plot3d_mesh}
\alias{plot3d_mesh}
\title{Plot a three dimensional mesh}
\usage{
plot3d_mesh(
  mesh,
  engine3d = NULL,
  color.nodes = "black",
  color.mesh = "darkgray",
  alpha = 0.4,
  ...
)
}
\arguments{
\item{mesh}{3-dimensional mesh to draw}

\item{engine3d}{3d framework to use: 'rgl' if installed or 'scatterplot3d' (default)}

\item{color.nodes}{color of the mesh nodes}

\item{color.mesh}{color of the mesh elements}

\item{alpha}{transparency of the mesh elements & nodes}

\item{...}{optional arguments passed to plot function}
}
\description{
Plot a three dimensional mesh
}
\examples{
if (identical(Sys.getenv("NOT_CRAN"), "true")) { # too long for CRAN on Windows

  plot3d_mesh(mesh_exsets(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2,
                          threshold = .25,sign=-1, mesh.type="unif",
                          maxerror_f=1E-2,tol=1E-2, # faster display
                          intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2)),
                          engine3d='scatterplot3d')

  if (requireNamespace("rgl")) {
    plot3d_mesh(mesh_exsets(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2,
                            threshold = .25,sign=-1, mesh.type="unif",
                            maxerror_f=1E-2,tol=1E-2, # faster display
                            intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2)),engine3d='rgl')
  }
}
}
