% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root.R
\name{roots_mesh}
\alias{roots_mesh}
\title{Multi Dimensional Multiple Roots (Zero) Finding, sampled by a mesh}
\usage{
roots_mesh(
  f,
  vectorized = FALSE,
  intervals,
  mesh.type = "seq",
  mesh.sizes = 11,
  maxerror_f = 1e-07,
  tol = .Machine$double.eps^0.25,
  ...
)
}
\arguments{
\item{f}{Function (one or more dimensions) to find roots of}

\item{vectorized}{is f already vectorized ? (default: no)}

\item{intervals}{bounds to inverse in, each column contains min and max of each dimension}

\item{mesh.type}{function or "unif" or "seq" (default) to preform interval partition}

\item{mesh.sizes}{number of parts for mesh (duplicate for each dimension if using "seq")}

\item{maxerror_f}{the maximum error on f evaluation (iterates over uniroot to converge).}

\item{tol}{the desired accuracy (convergence tolerance on f arg).}

\item{...}{Other args for f}
}
\value{
matrix of x, so f(x)=0
}
\description{
Multi Dimensional Multiple Roots (Zero) Finding, sampled by a mesh
}
\examples{
roots_mesh(function(x) x-.51, intervals=rbind(0,1))
roots_mesh(function(x) sum(x)-.51, intervals=cbind(rbind(0,1),rbind(0,1)))
roots_mesh(sin,intervals=c(pi/2,5*pi/2))
roots_mesh(f = function(x) sin(pi*x[1])*sin(pi*x[2]),
           intervals = matrix(c(1/2,5/2,1/2,5/2),nrow=2))

r = roots_mesh(f = function(x) (0.25+x[1])^2+(0.5+x[2])^2 - .25,
intervals=matrix(c(-1,1,-1,1),nrow=2), mesh.size=5)
plot(r,xlim=c(-1,1),ylim=c(-1,1))

r = roots_mesh(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2 - .5,
               mesh.sizes = 11,
               intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2))
scatterplot3d::scatterplot3d(r,xlim=c(-1,1),ylim=c(-1,1),zlim=c(-1,1))

roots_mesh(function(x)exp(x)-1,intervals=c(-1,2))
roots_mesh(function(x)exp(1000*x)-1,intervals=c(-1,2))
}
