% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DirectEffects.R
\name{sequential_g}
\alias{sequential_g}
\title{Peform linear sequential g-estimation to estimate the controlled
direct effect of a treatment net the effect of a mediator.}
\usage{
sequential_g(formula, first_mod, data, subset, weights, na.action,
  model = TRUE, y = TRUE, x = FALSE, offset, contrasts = NULL, ...)
}
\arguments{
\item{formula}{formula specification of the direct effect and blip-down models.
Should be of the form \code{y ~ tr + x1 + x2 | med} where \code{tr} is the
name of the treatment variable, \code{med} is the name of the mediator
and \code{x1} and \code{x2} are baseline covariates. Before the \code{|} bar
represents the direct effects model and after the bar represents
the blip-down model, the latter of which will be used to created
the blipped down outcome.}

\item{first_mod}{an \code{lm} output containing the first-stage
regression model. Must contain a coefficient for all variables in
the blip-down model in the \code{formula} argument.}

\item{data}{an optional data frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data frame) containing
    the variables in the model.  If not found in \code{data}, the
    variables are taken from \code{environment(formula)},
    typically the environment from which \code{lm} is called.}

\item{subset}{an optional vector specifying a subset of observations
    to be used in the fitting process.}

\item{weights}{an optional vector of weights to be used in the fitting
    process.  Should be \code{NULL} or a numeric vector.
    If non-NULL, weighted least squares is used with weights
    \code{weights} (that is, minimizing \code{sum(w*e^2)}); otherwise
    ordinary least squares is used.  See also \sQuote{Details},}

\item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.  The default is set by
    the \code{na.action} setting of \code{\link{options}}, and is
    \code{\link{na.fail}} if that is unset.  The \sQuote{factory-fresh}
    default is \code{\link{na.omit}}.  Another possible value is
    \code{NULL}, no action.  Value \code{\link{na.exclude}} can be useful.}

\item{model}{logical indicating whether the resulting model frame
should be returned.}

\item{y}{logical indicating whether the blipped-down outcome
vector should be returned.}

\item{x}{logical indicating whether the model matrix of the direct
effects model should be returned.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector of length equal to
    the number of cases.  One or more \code{\link{offset}} terms can be
    included in the formula instead or as well, and if more than one are
    specified their sum is used.  See \code{\link{model.offset}}.}

\item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{\link{model.matrix.default}}.}

\item{...}{additional arguments to be passed to the low level
    regression fitting functions (see below).}
}
\value{
Returns an object of \code{class} A \code{"seqg"}. Similar
to the output of a call to \code{lm}. Contains the following
components:
\itemize{
  \item coefficients: a vector of named coefficients for the direct
effects model.
  \item residuals: the residuals, that is the blipped-down outcome
minus the fitted values.
  \item rank: the numeric rank of the fitted linear direct effects
model.
  \item fitted.values: the fitted mean values of the direct effects
model.
  \item weights: (only for weighted fits) the specified weights.
  \item df.residual: the residual degrees of freedom for the direct
effects model.
  \item terms: the \code{terms} object used.
  \item formula: the \code{formula} object used, possibly modified
to drop a constant in the blip-down model.
  \item call: the matched call.
  \item contrasts:  the contrasts used for the factor variables.
  \item levels: the levels of the factor variables.
  \item first_mod: the first_mod object used.
  \item vcov: covariance matrix of the direct-effects coefficients.
  \item model: full model frame (if \code{model = TRUE}).
  \item y: the blipped-down response vector (if \code{y = TRUE}).
  \item x: the direct effects model matrix (if \code{x = TRUE}).
}
In addition, non-null fits will have components \code{assign},
\code{effects}, and \code{qr} from the output of \code{lm.fit} or
\code{lm.wfit}, whichever is used.
}
\description{
Peform linear sequential g-estimation to estimate the controlled
direct effect of a treatment net the effect of a mediator.
}
\details{
The \code{sequential_g} function implements the linear
sequential g-estimator developed by Vansteelandt (2009) with the
consistent variance estimator developed by Acharya, Blackwell, and
Sen (2016).

The function takes in a first-stage linear model, \code{first_mod},
of the \code{lm} class which is assumed to estimate the effect of
the mediator on the outcome (conditional on the treatment,
intermediate confounders, and baseline confounders). The formula
specifies both the second stage, direct effect model of the
treatment and baseline confounders, but also contains the
specification of the 'blip-down' or 'demediation' function that is
used to remove the average effect of the mediator (possibly
interacted) from the outcome to create the blipped-down outcome.
This blipped-down outcome is the passed to a standard linear model
with the covariates as specified for the direct effects model.

See the references below for more details.
}
\examples{
data(ploughs)
ploughs$centered_ln_inc <- ploughs$ln_income - mean(ploughs$ln_income, na.rm = TRUE)
ploughs$centered_ln_incsq <- ploughs$centered_ln_inc^2

fit_first <- lm(women_politics ~ plow + centered_ln_inc +
                centered_ln_incsq + agricultural_suitability +
                tropical_climate +  large_animals +
                political_hierarchies + economic_complexity +
                rugged + years_civil_conflict +
                years_interstate_conflict  + oil_pc +
                european_descent + communist_dummy + polity2_2000 +
                serv_va_gdp2000, data = ploughs)

form_main <- women_politics ~ plow + agricultural_suitability +
  tropical_climate +  large_animals + political_hierarchies +
  economic_complexity + rugged | centered_ln_inc +
  centered_ln_incsq

direct <- sequential_g(formula = form_main,
                      first_mod = fit_first,
                      data = ploughs,
                      subset = rownames(ploughs) \%in\%
  rownames(model.matrix(fit_first)))

summary(direct)
}
\references{
Vansteelandt, S. (2009). Estimating Direct Effects in
Cohort and Case-Control Studies. Epidemiology, 20(6), 851-860.

Acharya, Avidit, Blackwell, Matthew, and Sen, Maya. (2016)
"Explaning Causal Effects Without Bias: Detecting and Assessing
Direct Effects." American Political Science Review 110:3 pp.
  512-529
}
