% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{generate.pvalues}
\alias{generate.pvalues}
\title{Generation of P-Values and Their Supports After Data Transformations}
\usage{
generate.pvalues(
  dat,
  test.fun,
  test.args = NULL,
  preprocess.fun = NULL,
  preprocess.args = NULL
)
}
\arguments{
\item{dat}{input data; must be suitable for the first parameter of the provided \code{preprocess.fun} function or, if \code{preprocess.fun} is \code{NULL}, for the first parameter of the \code{test.fun} function.}

\item{test.fun}{function \strong{from package \code{\link[DiscreteTests:DiscreteTests-package]{DiscreteTests}}}, i.e. one whose name ends with \verb{*.test.pv} and which performs hypothesis tests and provides an object with p-values and their support sets; can be specified by a single character string (which is automatically checked for being a suitable function \strong{from that package} and may be abbreviated) or a single function object.}

\item{test.args}{optional named list with arguments for \code{test.fun}; the names of the list fields must match the test function's parameter names. The first parameter of the test function MUST NOT be included!}

\item{preprocess.fun}{optional function for pre-processing the input \code{data}; its result must be suitable for the first parameter of the \code{test.fun} function.}

\item{preprocess.args}{optional named list with arguments for \code{preprocess.fun}; the names of the list fields must match the pre-processing function's parameter names. The first parameter of the test function MUST NOT be included!}
}
\value{
A \link[DiscreteTests:DiscreteTestResults]{DiscreteTestResults} R6 class object.
}
\description{
Simple wrapper for generating p-values of discrete tests and their supports
after pre-processing the input data. The user only has to provide 1.) a
function that generates p-values and supports and 2.) an optional function
that pre-processes (i.e. transforms) the input data (if necessary) before it
can be used for p-value calculations. The respective arguments are provided
by named lists.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

# Compute p-values and their supports of Fisher's exact test with pre-processing
df2 <- data.frame(X1, N1, X2, N2)
generate.pvalues(
  dat = df2,
  test.fun = "fisher.test.pv",
  preprocess.fun = function(tab) {
    for(col in c(2, 4)) tab[, col] <- tab[, col] - tab[, col - 1]
    return(tab)
  }
)

# Compute p-values and their supports of a binomial test with pre-processing
generate.pvalues(
  dat = rbind(c(5, 2, 7), c(3, 4, 0)), 
  test.fun = "binom.test.pv",
  test.args = list(n = c(9, 8, 11), p = 0.6, alternative = "two.sided"),
  preprocess.fun = colSums
)

}
