% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGF_norm.R
\name{MGF_norm}
\alias{MGF_norm}
\title{Moment Generating Function of the Normal distribution}
\usage{
MGF_norm(t, mean = 0, sd = 1)
}
\arguments{
\item{t}{t.}

\item{mean}{mean (location) parameter \eqn{\mu}{mu}.}

\item{sd}{standard deviation \eqn{\sigma}{sigma}, must be positive.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_norm}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_norm}}}{ gives the expected value.}
 \item{\code{\link{V_norm}}}{ gives the variance.}
 \item{\code{\link{Etronq_norm}}}{ gives the truncated mean.}
 \item{\code{\link{SL_norm}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_norm}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_norm}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_norm}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_norm}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Moment Generating Function (MGF) of the Normal distribution
  with mean \eqn{\mu}{mu} and variance \eqn{\sigma}{sigma}.
}
\details{
The Normal distribution with mean \eqn{\mu}{mu} and standard deviation
  \eqn{\sigma}{sigma} has density:
  \deqn{\frac{1}{\sqrt{2\pi}\sigma}\textrm{e}^{-\frac{1}{2}\left(\frac{x - \mu}{\sigma}\right)^2}}{f(x) = e^(-(1/2) ((x - mu)/sigma)^2) / ((2 pi)^(1/2) sigma}
  for \eqn{x \in \mathcal{R}}{x real}, \eqn{\mu \in \mathcal{R}, \sigma > 0}{mu real, sigma > 0}.
}
\examples{

MGF_norm(t = 1, mean = 3, sd = 5)

}
\seealso{
Other Normal distribution: 
\code{\link{E_norm}()},
\code{\link{Elim_norm}()},
\code{\link{Etronq_norm}()},
\code{\link{Mexcess_norm}()},
\code{\link{SL_norm}()},
\code{\link{TVaR_norm}()},
\code{\link{V_norm}()},
\code{\link{VaR_norm}()}
}
\concept{Normal distribution}
