% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{diversityoccu}
\alias{diversityoccu}
\title{Calculates alpha diversity from multiple species occupancy data}
\usage{
diversityoccu(pres, sitecov, obscov, spp, form, index = "shannon",
  dredge = FALSE, pos = 1, envir = as.environment(pos))
}
\arguments{
\item{pres}{a data.frame where rows are the sites and columns are a series of
presence-absence observation from multiple species, every species needs to
have the same number of observations.}

\item{sitecov}{a data.frame where every row is a site, and every column is a
measurement of that site, such as elevation or slope, this covariates are
usually more constant.}

\item{obscov}{a list where every element is a data frame with the daily
covariates for each site, that is a measurement for each day, such as average
temperature of a day, this covariates are usually very .}

\item{spp}{the number of species in the pres data.frame}

\item{form}{a formula in the format ~ obscov ~ sitcov, the first arguments
will be used to calculate probability of detection and the second part the
occupancy.}

\item{index}{Diversity index, one of "shannon", "simpson" or "invsimpson".}

\item{dredge}{default = FALSE, if TRUE, for each species, the best occupancy
model will be determined by fitting all possible models and ranking by AICc.}

\item{pos}{where to do the removal. By default, uses the current environment.}

\item{envir}{the environment to use.}
}
\value{
A list with the fitted models for each species, the calculated
Alpha diversity for each site, and a dataframe with the abundance of each
species and diversity.
}
\description{
This function takes a data.frame with multiple presence absence-data from
various species in different sites, covariates of each site to calculate
occupancy, variables specific to sampling days to calculate probability of
detection, and it calculates the alpha diversity for each site.
}
\details{
This function fits the latent abundance mixture model described in Royle and
Nichols (2003), to calculate the abundance of every species in each site, the
using that abundance it calculates the alpha diversity index for each site
based on that abundance.
}
\examples{
\dontrun{
#Load the data
data("IslandBirds")
data("Daily_Cov")
data("siteCov")

#Model the abundance for  5 bird species and calculate alpha diversity from that

BirdDiversity <-diversityoccu(pres = IslandBirds, sitecov = siteCov,
obscov = Daily_Cov,spp =  5, form = ~ Day + Wind + Time + Rain +
Noise ~ Elev + AgroFo + SecVec + Wetland + Upland)

#To see the estimates and p values for each model:

BirdDiversity$models
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

Nicole L. Michel
}
\seealso{
\code{\link[vegan]{diversity}}

\code{\link[DiversityOccupancy]{model.diversity}}
}

