\name{fac.design}
\alias{fac.design}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Function for full factorial designs }
\description{
  Function for creating full factorial designs with arbitrary numbers of levels
}
\usage{
fac.design(nlevels=NULL, nfactors=NULL, factor.names = NULL, 
        replications=1, repeat.only = FALSE, randomize=TRUE, seed=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{nlevels}{ number(s) of levels, vector with \code{nfactors} entries or single number; 
                  can be omitted, if obvious from \code{factor.names} }
  \item{nfactors}{ number of factors, can be omitted if obvious from entries \code{nlevels} or \code{factor.names} }
  \item{factor.names}{ if \code{nlevels} is given, \code{factor.names} can be a character vector of factor names. 
        In this case, default factor levels are the numbers from 1 to the number of levels for each factor.\cr
        Otherwise it must be a list of vectors with factor levels. 
        If the list is named, list names represent factor names, otherwise default factor names are used.
        Default factor names are the first elements of the character vector \code{\link{Letters}}, 
        or the factors position numbers preceded by capital F in case of more than 50 factors.
        If both \code{nlevels} and factor.names are 
        given, they must be compatible.}
  \item{replications}{ positive integer number. Default 1 (i.e. each row just once). 
       If larger, each design run is executed replication times. 
       If \code{repeat.only}, repeated measurements 
       are carried out directly in sequence, i.e. no true replication takes place, 
       and all the repeat runs are conducted together. It is likely that the error 
       variation generated by such a procedure will be too small, so that average values 
       should be analyzed for an unreplicated design. 
       
       Otherwise (default), the full experiment is first carried out once, then 
       for the second replication and so forth. In case of randomization, 
       each such blocks is randomized separately. In this case, replication variance is 
       more likely suitable for usage as error variance 
       (unless e.g. the same parts are used for replication runs although build 
       variation is important).}
  \item{repeat.only}{ logical, relevant only if replications > 1. If \code{TRUE}, 
        replications of each run are grouped together 
       (repeated measurement rather than true replication). The default is 
       \code{repeat.only=FALSE}, i.e. the complete experiment 
       is conducted in \code{replications} blocks, and each run occurs in each block.  }
  \item{randomize}{ logical. If \code{TRUE}, the design is randomized. This is the default. 
       In case of replications, the nature of randomization depends on the setting of 
       option \code{repeat.only}.}
  \item{seed}{ optional seed for the randomization process }
}
\details{
   \code{fac.design} creates full factorial designs, i.e. the number of runs is the 
   product of all numbers of levels.
   
}
\value{
    \code{fac.design} returns a data frame of S3 class \code{\link{design}} 
    with attributes attached. 

   The experimental factors are all stored as R factors. \cr
   For factors with 2 levels, \code{\link{contr.FrF2}} contrasts (-1 / +1) are used. \cr
   For factors with more than 2 numerical levels, polynomial contrasts are used 
   (i.e. analyses will per default use orthogonal polynomials). \cr
   For factors with more than 2 categorical levels, the default contrasts are used.
   
   Future versions will most likely allow more user control about the type of 
   contrasts to be used.
   
   The \code{design.info} attribute of the data frame has the element 
   \code{nlevels} in addition to the standard elements documented for class \code{\link{design}}.
}
\references{ 
  Hedayat, A.S., Sloane, N.J.A. and Stufken, J. (1999) \emph{Orthogonal Arrays: Theory and Applications}, Springer, New York. 
}
\author{ Ulrike Groemping }
\note{ This package is currently under intensive development. Substantial changes are to be expected in the near future.}
\seealso{ See also \code{\link[FrF2]{FrF2}}, \code{\link{oa.design}}, \code{\link[FrF2]{pb}} } 
\examples{
  ## only specify level combination 
  fac.design(nlevels=c(4,3,3,2))
  ## design requested via factor.names
  fac.design(factor.names=list(one=c("a","b","c"), two=c(125,275), three=c("old","new"), four=c(-1,1), five=c("min","medium","max")))
  ## design requested via character factor.names and nlevels (with a little German lesson for one two three)
  fac.design(factor.names=c("eins","zwei","drei"),nlevels=c(2,3,2))
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ array }
\keyword{ design }% __ONLY ONE__ keyword per line
