% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R
\name{runDockerServer}
\alias{runDockerServer}
\title{Run the server container}
\usage{
runDockerServer(provider, cluster, container, hardware, verbose)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{container}{S4 \code{DockerContainer} Object. The server container.}

\item{hardware}{S4 \code{DockerHardware} Object. The server hardware.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
Any object that can be used by the cluster to identify the server instance.
}
\description{
Run the server and return the server instance handle. There is no default method
for this generic.
}
\section{Instance Handle}{

The instance handle is nothing but any data type that can be used by the
cloud provider to identify the running container. The data type should
supports \code{identical} and \code{unique} functions. The \code{DockerParallel} object will use the
handle to check the instance status or kill the instance. Though it is not required,
but we recommend to use \code{character} as the instance handle.
}

