% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChristoffersenBacktestForIndependence.R
\name{ChristoffersenBacktestForIndependence}
\alias{ChristoffersenBacktestForIndependence}
\title{Christoffersen Backtest for Independence}
\usage{
ChristoffersenBacktestForIndependence(Ra, Rb, cl)
}
\arguments{
\item{Ra}{Vector of portfolio profit and loss observations}

\item{Rb}{Vector of corresponding VaR forecasts}

\item{cl}{Confidence interval for}
}
\value{
Probability that given the data set, the null hypothesis
(i.e. independence) is correct.
}
\description{
Carries out the Christoffersen backtest of independence for a VaR risk
measurement model, for specified VaR confidence level.
}
\examples{
# Has to be modified with appropriate data:
   # Christoffersen Backtest For Independence for given parameters
   a <- rnorm(1*100)
   b <- abs(rnorm(1*100))+2
   ChristoffersenBacktestForIndependence(a, b, 0.95)
}
\author{
Dinesh Acharya

Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Christoffersen, P. Evaluating Interval Forecasts. International Economic
Review, 39(4), 1992, 841-862.
}

