% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KSTestStat.R
\name{KSTestStat}
\alias{KSTestStat}
\title{Plots cumulative density for KS test and computes confidence interval for
KS test stat.}
\usage{
KSTestStat(number.trials, sample.size, confidence.interval)
}
\arguments{
\item{number.trials}{Number of trials}

\item{sample.size}{Sizes of the trial samples}

\item{confidence.interval}{Confidence interval expressed as a fraction of 1}
}
\value{
Confidence Interval for KS test stat
}
\description{
Kolmogorov-Smirnov (KS) test statistic is a non parametric test for
distribution equality and measures the maximum distance between two cdfs.
Formally, the KS test statistic is : \deqn{D=\max_i|F(X_i)-\hat{F}(X_i)|}
}
\examples{
# Plots the cdf for KS Test statistic and returns KS confidence interval
   # for 100 trials with 1000 sample size and 0.95 confidence interval
   KSTestStat(100, 1000, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Chakravarti, I. M., Laha, R. G. and Roy, J. Handbook of Methods of #' Applied Statistics, Volume 1, Wiley, 1967.
}

