% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tESPlot2DCL.R
\name{tESPlot2DCL}
\alias{tESPlot2DCL}
\title{Plots t- ES against confidence level}
\usage{
tESPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 df Number of degrees of freedom in the t distribution

 cl ES confidence level and must be a vector

 hp ES holding period and must be a scalar}
}
\description{
Plots the ES of a portfolio against confidence level, assuming that L/P is
t distributed, for specified confidence level and holding period.
}
\examples{
# Computes ES given geometric return data
   data <- runif(5, min = 0, max = .2)
   tESPlot2DCL(returns = data, df = 6, cl = seq(.9,.99,.01), hp = 60)

   # Computes v given mean and standard deviation of return data
   tESPlot2DCL(mu = .012, sigma = .03, df = 6, cl = seq(.9,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Evans, M., Hastings, M. and Peacock, B. Statistical Distributions, 3rd
edition, New York: John Wiley, ch. 38,39.
}

