% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDrugUtilisationCohortSet.R
\name{generateDrugUtilisationCohortSet}
\alias{generateDrugUtilisationCohortSet}
\title{Generate a set of drug cohorts based on given concepts}
\usage{
generateDrugUtilisationCohortSet(
  cdm,
  name,
  conceptSet,
  gapEra = 1,
  durationRange = lifecycle::deprecated(),
  imputeDuration = lifecycle::deprecated(),
  priorUseWashout = lifecycle::deprecated(),
  priorObservation = lifecycle::deprecated(),
  cohortDateRange = lifecycle::deprecated(),
  limit = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{The name of the new cohort table to add to the cdm reference.}

\item{conceptSet}{The concepts used to create the cohort, provide as a
codelist or concept set expression.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era. Records that have fewer days between them than
this gap will be concatenated into the same cohort record.}

\item{durationRange}{Deprecated.}

\item{imputeDuration}{Deprecated.}

\item{priorUseWashout}{Deprecated.}

\item{priorObservation}{Deprecated.}

\item{cohortDateRange}{Deprecated.}

\item{limit}{Deprecated.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records with the specified concepts. Cohort start and end dates will
be based on drug record start and end dates, respectively. Records that
overlap or have fewer days between them than the specified gap era will be
concatenated into a single cohort entry.
}
\examples{
\donttest{
library(CDMConnector)
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

druglist <- CodelistGenerator::getDrugIngredientCodes(
  cdm, c("acetaminophen", "metformin")
)

cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "drug_cohorts",
  conceptSet = druglist
)

cdm$drug_cohorts |>
  glimpse()
}

}
