% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableTreatment}
\alias{tableTreatment}
\title{Format a summarised_treatment result into a visual table.}
\usage{
tableTreatment(
  result,
  header = c("cdm_name", "cohort_name"),
  groupColumn = "variable_name",
  type = "gt",
  hide = c("window_name", "mutually_exclusive", "censor_date", "cohort_table_name",
    "index_date", "treatment_cohort_name"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default
values.}
}
\value{
A table with a formatted version of summariseTreatment() results.
}
\description{
Format a summarised_treatment result into a visual table.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

result <- cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )

tableTreatment(result)
}

}
