% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynCommPostProcess.R
\docType{data}
\name{APIFUNCTIONS}
\alias{APIFUNCTIONS}
\title{List of API functions.}
\format{
A named list with the names of all API functions:
 \describe{
   \item{COMMUNITIES}{Get all communities after the last iteration. See \code{\link{communities}}}
   \item{COMMUNITIESEDGECOUNT}{Get the number of community to community edges in the graph. See \code{\link{communitiesEdgeCount}}}
   \item{COMMUNITY}{Get the community of the given vertex after the last iteration. See \code{\link{community}}}
   \item{COMMUNITYCOUNT}{Get the number of communities after the last iteration. See \code{\link{communityCount}}}
   \item{COMMUNITYEDGEWEIGHT}{Get the weight of the edge that goes from source to destination after the last iteration. See \code{\link{communityEdgeWeight}}}
   \item{COMMUNITYINNEREDGESWEIGHT}{Get the sum of weights of the inner edges of the given community after the last iteration. See \code{\link{communityInnerEdgesWeight}}}
   \item{COMMUNITYMAPPINGMATRIX}{Get a matrix with the community mapping for all communities after the last iteration.See \code{\link{communityMapping}}}
   \item{COMMUNITYMAPPINGFILE}{Write to a file the community mapping for all communities after the last iteration.See \code{\link{communityMapping}}}
   \item{COMMUNITYNEIGHBOURS}{Get the neighbours of the given community after the last iteration. See \code{\link{communityNeighbours}}}
   \item{COMMUNITYTOTALWEIGHT}{Get the sum of weights of all edges of the given community after the last iteration. See \code{\link{communityTotalWeight}}}
   \item{COMMUNITYVERTEXCOUNT}{Get the amount of vertices in the given community after the last iteration. See \code{\link{communityVertexCount}}}
   \item{EDGECOUNT}{Get the number of vertex to vertex edges in the graph. See \code{\link{edgeCount}}}
   \item{EDGEWEIGHT}{Get the weight of the edge that goes from source vertex to destination vertex after the last iteration. See \code{\link{edgeWeight}}}
   \item{NEIGHBOURS}{Get the neighbours of the given vertex after the last iteration. See \code{\link{neighbours}}}
   \item{QUALITY}{Get the quality measurement of the graph after the last iteration. See \code{\link{quality}}}
   \item{RESULTS}{Get additional results of the algorithm or the currently selected post processing steps. See \code{\link{results}}}
   \item{VERTEXCOUNT}{Get the total number of vertices after the last iteration. See \code{\link{vertexCount}}}
   \item{VERTICESALL}{Get all vertices in the graph after the last iteration. See \code{\link{verticesAll}}}
   \item{VERTICES}{Get all vertices belonging to the given community after the last iteration. See \code{\link{vertices}}}
 }
}
\usage{
APIFUNCTIONS
}
\description{
This is a list of all functions of the API.
}
\details{
Post processing algorithms must register, which functions of the API they 
implement, in a has() function. If the post processing algorithm implements 
a certain API function, the has() function must return TRUE when questioned 
about that API function. Otherwise, it must return FALSE.
}
\seealso{
\code{\link{DynComm}}
}
\author{
poltergeist0
}
\keyword{internal}
