% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHLS.R
\name{plot.MHLS}
\alias{plot.MHLS}
\title{Plot Metropolis-Hastings sampler outputs}
\usage{
\method{plot}{MHLS}(x, index = 1:ncol(x$beta), skipS = FALSE, ...)
}
\arguments{
\item{x}{an object of class "MHLS", which is an output of \code{\link{MHLS}}.}

\item{index}{an index of covariates to plot.}

\item{skipS}{logical. If \code{skipS = TRUE}, plots beta only.}

\item{...}{additional arguments passed to or from other methods.}
}
\description{
Provides six plots for each covariate index;
 histogram, path plot and acf plot for beta and for its subgradient.
}
\details{
\code{\link{plot.MHLS}} provides summary plots of beta and subgradient.
 The first column provides histogram of beta and subgradient, while the second
 and the third columns provide path and acf plots, respectively.
 If \code{skipS = TRUE}, this function provides summary plots for beta only.
}
\examples{
#' set.seed(123)
n <- 10
p <- 5
X <- matrix(rnorm(n * p), n)
Y <- X \%*\% rep(1, p) + rnorm(n)
sigma2 <- 1
lbd <- .37
weights <- rep(1, p)
LassoResult <- lassoFit(X = X, Y = Y, lbd = lbd, type="lasso", weights = weights)
B0 <- LassoResult$B0
S0 <- LassoResult$S0
plot(MHLS(X = X, PE = rep(0, p), sig2 = 1, lbd = 1, group = 1:p,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     type = "coeff"))
}
