% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstlib.R
\name{ecos.control}
\alias{ecos.control}
\title{Return the default optimization parameters for ECOS}
\usage{
ecos.control(maxit = 100L, feastol = 1e-08, reltol = 1e-08,
  abstol = 1e-08, feastol_inacc = 1e-04, abstol_inacc = 5e-05,
  reltol_inacc = 5e-05, verbose = 0L, mi_max_iters = 1000L,
  mi_int_tol = 1e-04, mi_abs_eps = 1e-06, mi_rel_eps = 1e-06)
}
\arguments{
\item{maxit}{the maximum number of iterations for ecos, default 100L}

\item{feastol}{the tolerance on the primal and dual residual, default 1e-8}

\item{reltol}{the relative tolerance on the duality gap, default 1e-8}

\item{abstol}{the absolute tolerance on the duality gap, default 1e-8}

\item{feastol_inacc}{the tolerance on the primal and dual residual if reduced precisions, default 1e-4}

\item{abstol_inacc}{the absolute tolerance on the duality gap if reduced precision, default 5e-5}

\item{reltol_inacc}{the relative tolerance on the duality gap if reduced precision, default 5e-5}

\item{verbose}{verbosity level, default 0L. A verbosity level of 1L will show more detail, but clutter session transcript.}

\item{mi_max_iters}{the maximum number of branch and bound iterations (mixed integer problems only), default 1000L}

\item{mi_int_tol}{the integer tolerence (mixed integer problems only), default 1e-4}

\item{mi_abs_eps}{the absolute tolerance between upper and lower bounds (mixed integer problems only), default 1e-6}

\item{mi_rel_eps}{the relative tolerance, \eqn{(U-L)/L}, between upper and lower bounds (mixed integer problems only), default 1e-6}
}
\value{
a list with the following elements:
 \describe{
   \item{FEASTOL}{ the tolerance on the primal and dual residual, parameter \code{feastol}}
   \item{ABSTOL}{ the absolute tolerance on the duality gap, parameter \code{abstol}}
   \item{RELTOL}{ the relative tolerance on the duality gap, parameter \code{reltol}}
   \item{FEASTOL_INACC}{ the tolerance on the primal and dual residual if reduced precisions, parameter \code{feastol_inacc}}
   \item{ABSTOL_INACC}{ the absolute tolerance on the duality gap if reduced precision, parameter \code{abstol_inacc}}
   \item{RELTOL_INACC}{ the relative tolerance on the duality gap if reduced precision, parameter \code{reltol_inacc}}
   \item{MAXIT}{ the maximum number of iterations for ecos, parameter \code{maxit}}
   \item{MI_MAX_ITERS}{ the maximum number of branch and bound iterations (mixed integer problems only), parameter \code{mi_max_iters}}
   \item{MI_INT_TOL}{ the integer tolerence (mixed integer problems only), parameter \code{mi_int_tol}}
   \item{MI_ABS_EPS}{ the absolute tolerance between upper and lower bounds (mixed integer problems only), parameter \code{mi_abs_eps}}
   \item{MI_REL_EPS}{ the relative tolerance, \eqn{(U-L)/L}, between upper and lower bounds (mixed integer problems only), parameter \code{mi_rel_eps}}
   \item{VERBOSE}{ verbosity level, parameter \code{verbose}}
  }
}
\description{
This is used to control the behavior of the underlying optimization code.
}
