% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_access.r, R/init.r
\name{get_ecotox_sqlite_file}
\alias{get_ecotox_sqlite_file}
\alias{get_ecotox_path}
\title{The local path to the ECOTOX database (directory or sqlite file)}
\usage{
get_ecotox_sqlite_file(path = get_ecotox_path(), version)

get_ecotox_path()
}
\arguments{
\item{path}{When you have a copy of the database somewhere other than the default
directory (\code{\link{get_ecotox_path}()}), you can provide the path here.}

\item{version}{A \code{character} string referring to the release version of the database you wish to locate.
It should have the same format as the date in the EPA download link, which is month, day, year, separated by
underscores ("\%m_\%d_\%Y"). When missing, the most recent available copy is selected automatically.}
}
\value{
Returns a \code{character} string of the path.
\code{get_ecotox_path} will return the default directory of the database.
\code{get_ecotox_sqlite_file} will return the path to the sqlite file when it exists.
}
\description{
Obtain the local path to where the ECOTOX database is (or will be) placed.
}
\details{
It can be useful to know where the database is located on your disk. This function
returns the location as provided by \code{\link[rappdirs]{app_dir}}.
}
\examples{
get_ecotox_path()

\dontrun{
## This will only work if a local database exists:
get_ecotox_sqlite_file()
}
}
\author{
Pepijn de Vries
}
