# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simulate a sample path from an endpoint conditioned CTMC by modified
#' rejection sampling.
#'
#' @param a,b States at the interval endpoints, provided as integers
#'    corresponding to rows of the CTMC rate matrix.
#' @param t0,t1 times of the interval endpoints
#' @param Q CTMC rate matrix
#'
#' @return matrix whose first column is the sequence of transition times
#' bookended by interval endpoints, and whose second column is the sequence of
#' states
sample_path_mr <- function(a, b, t0, t1, Q) {
    .Call('ECctmc_sample_path_mr', PACKAGE = 'ECctmc', a, b, t0, t1, Q)
}

#' Simulate a sample path from an endpoint conditioned CTMC by uniformization.
#'
#' @param a,b States at the interval endpoints, provided as integers
#'    corresponding to rows of the CTMC rate matrix.
#' @param t0,t1 times of the interval endpoints
#' @param Q CTMC rate matrix
#'
#' @return matrix whose first column is the sequence of transition times
#' bookended by interval endpoints, and whose second column is the sequence of
#' states
sample_path_unif <- function(a, b, t0, t1, Q) {
    .Call('ECctmc_sample_path_unif', PACKAGE = 'ECctmc', a, b, t0, t1, Q)
}

#' Simulate a sample path from an endpoint conditioned CTMC by uniformization
#' using pre-computed eigen-values.
#'
#' @param a,b States at the interval endpoints, provided as integers
#'    corresponding to rows of the CTMC rate matrix.
#' @param t0,t1 times of the interval endpoints
#' @param Q CTMC rate matrix
#' @param eigen_vals vector of eigen values of Q.
#' @param eigen_vecs matrix of eigen vectors of Q.
#' @param inverse_vecs inverse of the eigen vector matrix.
#'
#' @return matrix whose first column is the sequence of transition times
#' bookended by interval endpoints, and whose second column is the sequence of
#' states
sample_path_unif2 <- function(a, b, t0, t1, Q, eigen_vals, eigen_vecs, inverse_vecs) {
    .Call('ECctmc_sample_path_unif2', PACKAGE = 'ECctmc', a, b, t0, t1, Q, eigen_vals, eigen_vecs, inverse_vecs)
}

