% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{assert_no_duplicate}
\alias{assert_no_duplicate}
\title{Assert that a dataset has one row per patient}
\usage{
assert_no_duplicate(df, id_col = get_key_cols())
}
\arguments{
\item{df}{the dataset}

\item{id_col}{\emph{(optional)} the name of the columns holding patient ID}
}
\value{
the \code{df} dataset, unchanged
}
\description{
Check that there is no duplicate on the column holding patient ID in a pipeable style. \cr
Mostly useful after joining two datasets.
}
\examples{
#without duplicate => no error, continue the pipeline
tibble(subjid=c(1:10)) \%>\% assert_no_duplicate() \%>\% nrow()

#with duplicate => throws an error
#tibble(subjid=c(1:10, 1:2)) \%>\% assert_no_duplicate() \%>\% nrow()
}
