% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_data_package.R
\name{create_data_package}
\alias{create_data_package}
\title{Create data package}
\usage{
create_data_package(eml, env = "production")
}
\arguments{
\item{eml}{(character) Full path to an EML file describing the data package
to be created}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
transaction (character) Transaction identifier. May be used in a
subsequent call to \code{check_status_create()} to determine the operation
status
}
\description{
Create data package
}
\details{
Each data entity described in \code{eml} must be accompanied by a
web accessible URL at the EML XPath ".//physical/distribution/online/url".
The EDI data repository downloads the data entities via this URL. The URLs
must be static and not have any redirects otherwise the data entities will
not be downloaded.
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create data package
transaction <- create_data_package(
  eml = paste0(tempdir(), "/edi.595.1.xml"),
  env = "staging"
)
transaction
#> [1] "create_163966765080210573__edi.595.1"

# Check creation status
status <- check_status_create(
  transaction = transaction,
  env = "staging"
)
status
#> [1] TRUE

logout()
}

}
\seealso{
Other Evaluation and Upload: 
\code{\link{check_status_create}()},
\code{\link{check_status_evaluate}()},
\code{\link{check_status_update}()},
\code{\link{evaluate_data_package}()},
\code{\link{update_data_package}()}
}
\concept{Evaluation and Upload}
