% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_status_update.R
\name{check_status_update}
\alias{check_status_update}
\title{Check data package update status}
\usage{
check_status_update(transaction, wait = TRUE, env = "production")
}
\arguments{
\item{transaction}{(character) Transaction identifier}

\item{wait}{(logical) Wait for evaluation to complete? See details below.}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if the update has completed, FALSE if in progress,
and error if an error was encountered while processing the request
}
\description{
Check data package update status
}
\details{
If \code{wait = TRUE}, then the function will enter a "while" loop
checking every 2 seconds for the completed evaluation report. If
\code{wait = FALSE}, then the function will only check once and return the
result.
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Update data package
transaction <- update_data_package(
  eml = paste0(tempdir(), "/edi.595.2.xml"),
  env = "staging"
)
transaction
#> [1] "update_edi.595_163966788658131920__edi.595.2"

# Check update status
status <- check_status_update(
  transaction = transaction,
  env = "staging"
)
status
#> [1] TRUE

logout()
}

}
\seealso{
Other Evaluation and Upload: 
\code{\link{check_status_create}()},
\code{\link{check_status_evaluate}()},
\code{\link{create_data_package}()},
\code{\link{evaluate_data_package}()},
\code{\link{update_data_package}()}
}
\concept{Evaluation and Upload}
