% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_get_stations.R
\name{EEAaq_get_stations}
\alias{EEAaq_get_stations}
\title{Download EEA measurement station information dataset}
\usage{
EEAaq_get_stations(byStation = FALSE, complete = TRUE)
}
\arguments{
\item{byStation}{Logic value (T or F). If \code{TRUE} the dataset is organized by station (one row for each measurement station).
If \code{FALSE} the dataset is organized by sampling point. Each station have multiple sampling points.}

\item{complete}{Logic value (T or F). If \code{TRUE}, the dataset contains all the variables given by the EEA.
If \code{FALSE} the dataset contains only a few variables, the most importants. For further details about the variables, see \code{\link{stations}}.}
}
\value{
A tibble containing the stations information. Further details available here \code{\link{stations}}.
}
\description{
Download the updated dataset from EEA, containing measurement station information. For further information about the variables
see \code{\link{stations}}.
}
\examples{
\donttest{EEAaq_get_stations(byStation = FALSE, complete = TRUE)}
}
