% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotReg.R
\name{plotReg}
\alias{plotReg}
\title{Plot regression coefficients for EEM data}
\usage{
plotReg(x, ncomp = NULL, ...)
}
\arguments{
\item{x}{output variable from \code{\link[pls]{plsr}} function}

\item{ncomp}{number of components}

\item{...}{(optional) arguments for \code{\link[EEM]{drawEEM}} and \code{\link[graphics]{filled.contour}}}
}
\value{
A figure is returned on the graphic device
}
\description{
Plot regression coefficients for EEM data
}
\examples{
data(gluten)
gluten_uf <- unfold(gluten) # unfold list into matrix

# delete columns with NA values
index <- colSums(is.na(gluten_uf)) == 0
gluten_uf <- gluten_uf[, index]
gluten_ratio <- as.numeric(names(gluten))

require(pls)
model <- plsr(gluten_ratio ~ gluten_uf, ncomp = 3)
plotReg(model)
}

