% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEML.R
\name{Weight}
\alias{Weight}
\title{Selection of Superior Models Using MSC Algorithm}
\usage{
Weight(ModelSel, Optim = "PSO")
}
\arguments{
\item{ModelSel}{Dataframe of predicted values of selected models with first column as actual values}

\item{Optim}{Optimisation technique}
}
\value{
\itemize{
  \item WeightEn: Ensemble weight of the candidate models
}
}
\description{
Selection of Superior Models Using MSC Algorithm
}
\examples{
\donttest{
library("EEML")
Actual<- as.ts(rnorm(200,100,50))
Model1<- as.ts(rnorm(200,100,50))
Model2<- as.ts(rnorm(200,100,50))
Model3<- as.ts(rnorm(200,100,50))
DF <- cbind(Actual, Model1,Model2,Model3)
SelModel<-Weight(ModelSel=DF,Optim="PSO")
}
}
\references{
\itemize{
\item Paul, R.K., Das, T. and Yeasin, M., 2023. Ensemble of time series and machine learning model for forecasting volatility in agricultural prices. National Academy Science Letters, 46(3), pp.185-188.
\item Yeasin, M. and Paul, R.K., 2024. OptiSembleForecasting: optimization-based ensemble forecasting using MCS algorithm and PCA-based error index. The Journal of Supercomputing, 80(2), pp.1568-1597.
}
}
