% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizor.R
\name{normalizor}
\alias{normalizor}
\title{Feature Normalization}
\usage{
normalizor(features)
}
\arguments{
\item{features}{A numeric matrix where each row represents an observation and each column represents a feature.}
}
\value{
A matrix of the same dimensions as \code{features}, where each feature has been normalized.
}
\description{
This function normalizes a matrix of features using precomputed means and standard deviations.
The function automatically runs \link[EFAfactors]{load_scaler} to read the standard deviations and means of the features,
which are organized into a \code{list} object named \code{scaler}. These means and standard deviations are computed from
the 10,000,000 datasets \code{\link[EFAfactors]{data.datasets}} for training the Pre-Trained Deep Neural Network (DNN).
}
\details{
The function applies z-score normalization to each element in the \code{features} matrix. It uses
the \code{scaler} object, which is expected to contain precomputed means and standard deviations for each feature.
The normalized value for each element is computed as:
\deqn{z = \frac{x - \mu}{\sigma}}
where \eqn{x} is the original value, \eqn{\mu} is the mean, and \eqn{\sigma} is the standard deviation.
}
\seealso{
\link[EFAfactors]{DNN_predictor}, \link[EFAfactors]{load_scaler}, \link[EFAfactors]{data.datasets}, \link[EFAfactors]{data.scaler}
}
