% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.COMPARE.R
\name{print.COMPARE}
\alias{print.COMPARE}
\title{Print COMPARE object}
\usage{
\method{print}{COMPARE}(x, ...)
}
\arguments{
\item{x}{list. An object of class COMPARE to be printed}

\item{...}{Further arguments for print.}
}
\description{
Print Method showing a summarized output of the \code{\link{COMPARE}} function.
}
\examples{
# A type SPSS EFA to mimick the SPSS implementation
EFA_SPSS_5 <- EFA(IDS2_R, n_factors = 5, type = "SPSS")

# A type psych EFA to mimick the psych::fa() implementation
EFA_psych_5 <- EFA(IDS2_R, n_factors = 5, type = "psych")

# compare the two
COMPARE(EFA_SPSS_5$unrot_loadings, EFA_psych_5$unrot_loadings,
        x_labels = c("SPSS", "psych"))
}
